/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.stats.BufferingInputStreamStats;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

@Tag(value="Sequential")
public class MiscTests {
    private static final AtomicLong skippedRawBytes = new AtomicLong(0L);
    private static final AtomicLong skippedInputStreamBytes = new AtomicLong(0L);
    private static final AtomicLong skippedRangeBytes = new AtomicLong(0L);
    public static final Stats STATS = new Stats(){

        public void skippedBytes(long length) {
            skippedRawBytes.addAndGet(length);
        }

        public BufferingInputStreamStats<SSTable> bufferingInputStreamStats() {
            return new BufferingInputStreamStats<SSTable>(){

                public void inputStreamBytesSkipped(CassandraFileSource<SSTable> ssTable, long bufferedSkipped, long rangeSkipped) {
                    skippedInputStreamBytes.addAndGet(bufferedSkipped);
                    skippedRangeBytes.addAndGet(rangeSkipped);
                }
            };
        }
    };

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testPartialRow(CassandraBridge bridge) {
        HashMap rows = new HashMap();
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.uuid()).withColumn("d", (CqlField.CqlType)bridge.aInt()).withColumn("e", (CqlField.CqlType)bridge.uuid()).withColumn("f", (CqlField.CqlType)bridge.aInt()).withInsertFields(new String[]{"a", "c", "e"})).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < 200; ++row) {
                UUID key = UUID.randomUUID();
                UUID value = UUID.randomUUID();
                rows.put(key, value);
                writer.write(new Object[]{key, value, value});
            }
        }).withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                Assertions.assertThat((int)row.size()).isEqualTo(6);
                UUID key = UUID.fromString(row.getString(0));
                UUID value1 = UUID.fromString(row.getString(2));
                UUID value2 = UUID.fromString(row.getString(4));
                Assertions.assertThat((boolean)rows.containsKey(key)).isTrue();
                Assertions.assertThat((Comparable)value1).isEqualTo(rows.get(key));
                Assertions.assertThat((Comparable)value2).isEqualTo((Object)value1);
                Assertions.assertThat((Object)row.get(1)).isNull();
                Assertions.assertThat((Object)row.get(3)).isNull();
                Assertions.assertThat((Object)row.get(5)).isNull();
            }
        }).withReset(rows::clear).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testPartialRowClusteringKeys(CassandraBridge bridge) {
        HashMap rows = new HashMap();
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.uuid()).withClusteringKey("c", (CqlField.CqlType)bridge.uuid()).withColumn("d", (CqlField.CqlType)bridge.text()).withColumn("e", (CqlField.CqlType)bridge.uuid()).withColumn("f", (CqlField.CqlType)bridge.aInt()).withColumn("g", (CqlField.CqlType)bridge.uuid()).withColumn("h", (CqlField.CqlType)bridge.aInt()).withInsertFields(new String[]{"a", "b", "c", "e", "g"})).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int row = 0; row < 200; ++row) {
                UUID a = UUID.randomUUID();
                UUID b = UUID.randomUUID();
                UUID c = UUID.randomUUID();
                UUID e = UUID.randomUUID();
                UUID g = UUID.randomUUID();
                String key = String.valueOf(a) + ":" + String.valueOf(b) + ":" + String.valueOf(c);
                String value = String.valueOf(e) + ":" + String.valueOf(g);
                rows.put(key, value);
                writer.write(new Object[]{a, b, c, e, g});
            }
        }).withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                Assertions.assertThat((int)row.size()).isEqualTo(8);
                String a = row.getString(0);
                String b = row.getString(1);
                String c = row.getString(2);
                String e = row.getString(4);
                String g = row.getString(6);
                String key = a + ":" + b + ":" + c;
                String value = e + ":" + g;
                Assertions.assertThat((boolean)rows.containsKey(key)).isTrue();
                Assertions.assertThat((String)value).isEqualTo((String)rows.get(key));
                Assertions.assertThat((Object)row.get(3)).isNull();
                Assertions.assertThat((Object)row.get(5)).isNull();
                Assertions.assertThat((Object)row.get(7)).isNull();
            }
        }).withReset(rows::clear).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedKeyspaceName(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testReservedWordKeyspaceName(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("keyspace").withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedTableName(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testReservedWordTableName(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("table").withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedPartitionKey(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("Partition_Key_0", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultipleQuotedPartitionKeys(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("Partition_Key_0", (CqlField.CqlType)bridge.uuid()).withPartitionKey("Partition_Key_1", (CqlField.CqlType)bridge.bigint()).withColumn("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.bigint()).withQuotedIdentifiers()).withExpectedRowCountPerSSTable(200).withSumField("d").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedPartitionClusteringKeys(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("Clustering_Key_0", (CqlField.CqlType)bridge.bigint()).withClusteringKey("Clustering_Key_1", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedColumnNames(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("Partition_Key_0", (CqlField.CqlType)bridge.uuid()).withColumn("Column_1", (CqlField.CqlType)bridge.varint()).withColumn("Column_2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testQuotedColumnNamesWithColumnFilter(CassandraBridge bridge) {
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace("Quoted_Keyspace_" + UUID.randomUUID().toString().replaceAll("-", "_")).withTable("Quoted_Table_" + UUID.randomUUID().toString().replaceAll("-", "_")).withPartitionKey("Partition_Key_0", (CqlField.CqlType)bridge.uuid()).withColumn("Column_1", (CqlField.CqlType)bridge.varint()).withColumn("Column_2", (CqlField.CqlType)bridge.text()).withQuotedIdentifiers()).withColumns("Partition_Key_0", "Column_1").run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSinglePartitionKeyWithNullValueColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withColumn("c", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultiplePartitionKeysWithNullValueColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withPartitionKey("b", (CqlField.CqlType)bridge.text()).withPartitionKey("d", (CqlField.CqlType)bridge.aDouble()).withColumn("c", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSinglePartitionAndClusteringKeyWithNullValueColumn(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsPrimaryKeyColumn).checkAssert(clusteringKeyType -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withClusteringKey("b", (CqlField.CqlType)clusteringKeyType).withColumn("c", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMultipleValueColumnsWithNullValueColumn(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsPrimaryKeyColumn).checkAssert(clusteringKeyType -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withClusteringKey("b", (CqlField.CqlType)clusteringKeyType).withColumn("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.aInt()).withColumn("e", (CqlField.CqlType)bridge.ascii()).withColumn("f", (CqlField.CqlType)bridge.blob())).withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testExcludeSomeColumnsWithNullValueColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withClusteringKey("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.text()).withColumn("d", (CqlField.CqlType)bridge.aInt()).withColumn("e", (CqlField.CqlType)bridge.ascii()).withColumn("f", (CqlField.CqlType)bridge.blob())).withColumns("a", "b", "d").withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testStaticColumnWithNullValueColumn(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.uuid()).withClusteringKey("b", (CqlField.CqlType)bridge.bigint()).withStaticColumn("c", (CqlField.CqlType)bridge.aInt()).withColumn("d", (CqlField.CqlType)bridge.text())).withExpectedRowCountPerSSTable(200).withNullRegularColumns().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNullValueColumnWithPushDownFilter(CassandraBridge bridge) {
        int numRows = 10;
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.aInt()).withColumn("b", (CqlField.CqlType)bridge.aInt())).dontWriteRandomData().withSSTableWriter(writer -> {
            for (int i = 0; i < numRows; ++i) {
                writer.write(new Object[]{i, null});
            }
        }).withFilter("a=1").withCheck(ds -> {
            for (Row row : ds.collectAsList()) {
                int a = row.getInt(0);
                Assertions.assertThat((int)a).isEqualTo(1);
                Assertions.assertThat((Object)row.get(1)).isNull();
            }
        }).run(bridge.getVersion());
    }

    private static void resetStats() {
        skippedRawBytes.set(0L);
        skippedInputStreamBytes.set(0L);
        skippedRangeBytes.set(0L);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testLargeBlobExclude(CassandraBridge bridge) {
        QuickTheory.qt().forAll(SourceDSL.booleans().all()).checkAssert(enableCompression -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.text()).withColumn("c", (CqlField.CqlType)bridge.blob()).withBlobSize(400000).withCompression(enableCompression.booleanValue())).withColumns("pk", "ck", "a").withExpectedRowCountPerSSTable(200).withStatsClass(MiscTests.class.getName() + ".STATS").withCheck(dataset -> {
            MiscTests.resetStats();
            List rows = dataset.collectAsList();
            Assertions.assertThat((boolean)rows.isEmpty()).isFalse();
            for (Row row : rows) {
                Assertions.assertThat((boolean)row.schema().getFieldIndex("pk").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("ck").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("a").isDefined()).isTrue();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("b").isDefined()).isFalse();
                Assertions.assertThat((boolean)row.schema().getFieldIndex("c").isDefined()).isFalse();
                Assertions.assertThat((int)row.length()).isEqualTo(3);
                Assertions.assertThat((boolean)(row.get(0) instanceof String)).isTrue();
                Assertions.assertThat((boolean)(row.get(1) instanceof Integer)).isTrue();
                Assertions.assertThat((boolean)(row.get(2) instanceof Long)).isTrue();
            }
            Assertions.assertThat((long)skippedRawBytes.get()).isGreaterThanOrEqualTo(50000000L);
            Assertions.assertThat((long)skippedInputStreamBytes.get()).isGreaterThanOrEqualTo(2500000L);
            Assertions.assertThat((long)skippedRangeBytes.get()).isGreaterThanOrEqualTo(5000000L);
        }).withReset(MiscTests::resetStats).run(bridge.getVersion()));
    }
}

