/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.PartitionedDataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.VersionRunner;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.data.partitioner.JDKSerializationTests;
import org.apache.cassandra.spark.data.partitioner.MultipleReplicasTests;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.reader.EmptyStreamScanner;
import org.apache.cassandra.spark.reader.StreamScanner;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.commons.lang3.RandomUtils;
import org.apache.spark.TaskContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.Generate;

public class PartitionedDataLayerTests
extends VersionRunner {
    int partitionId;

    @BeforeEach
    public void setup() {
        this.partitionId = TaskContext.getPartitionId();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSplitQuorumAllUp(CassandraBridge bridge) {
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.UP);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP);
    }

    @Test
    public void testSplitQuorumOneDown() {
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP);
    }

    @Test
    public void testSplitQuorumOneLeavingOrMoving() {
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.LEAVING);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.MOVING);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.UP);
    }

    @Test
    public void testSplitQuorumTwoDown() {
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(2, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN);
    }

    @Test
    public void testSplitAllWithLeavingAndMovingNodes() {
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.UNKNOWN);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(5, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.MOVING);
    }

    @Test
    public void testParsingAvailabilityHint() {
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"DOWN", (String)"NORMAL")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.DOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UP", (String)"MOVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.MOVING);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UP", (String)"LEAVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.LEAVING);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UP", (String)"NORMAL")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UP);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UP", (String)"STARTING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UP);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"DOWN", (String)"LEAVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.DOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"DOWN", (String)"MOVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.DOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"DOWN", (String)"NORMAL")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.DOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UNKNOWN", (String)"LEAVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UNKNOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UNKNOWN", (String)"MOVING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UNKNOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UNKNOWN", (String)"NORMAL")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UNKNOWN);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"UP", (String)"JOINING")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.JOINING);
        Assertions.assertThat((Comparable)PartitionedDataLayer.AvailabilityHint.fromState((String)"randomState", (String)"randomStatus")).isEqualTo((Object)PartitionedDataLayer.AvailabilityHint.UNKNOWN);
    }

    @Test
    public void testAvailabilityHintComparator() {
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.MOVING)).isEqualTo(-1);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.MOVING)).isEqualTo(0);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.MOVING)).isEqualTo(1);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.UNKNOWN)).isEqualTo(-1);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN)).isEqualTo(0);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.DOWN)).isEqualTo(0);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN)).isEqualTo(-1);
        Assertions.assertThat((int)PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR.compare(PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.UP)).isEqualTo(1);
    }

    @Test
    public void testSplitAll() {
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(1, PartitionedDataLayer.AvailabilityHint.UNKNOWN);
        PartitionedDataLayerTests.runSplitTests(3, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN);
        PartitionedDataLayerTests.runSplitTests(5, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.UP);
    }

    @Test
    public void testValidReplicationFactor() {
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ANY, (ReplicationFactor)TestUtils.simpleStrategy(), null);
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ANY, (ReplicationFactor)TestUtils.networkTopologyStrategy(), null);
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ANY, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3)), null);
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ANY, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3)), (String)"PV");
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.LOCAL_QUORUM, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3)), (String)"PV");
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ALL, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)3)), null);
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.EACH_QUORUM, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)3)), null);
        PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.ANY, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)3)), null);
    }

    @Test
    public void testReplicationFactorDCRequired() {
        Assertions.assertThatThrownBy(() -> PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.LOCAL_QUORUM, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)3)), null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testReplicationFactorUnknownDC() {
        Assertions.assertThatThrownBy(() -> PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.LOCAL_QUORUM, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)3)), (String)"ST")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testReplicationFactorRF0() {
        Assertions.assertThatThrownBy(() -> PartitionedDataLayer.validateReplicationFactor((ConsistencyLevel)ConsistencyLevel.LOCAL_QUORUM, (ReplicationFactor)TestUtils.networkTopologyStrategy((Map<String, Integer>)ImmutableMap.of((Object)"PV", (Object)3, (Object)"MR", (Object)0)), (String)"MR")).isInstanceOf(IllegalArgumentException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSSTableSupplier(CassandraBridge bridge) {
        CassandraRing ring = TestUtils.createRing(Partitioner.Murmur3Partitioner, 3);
        CqlTable table = TestSchema.basic((CassandraBridge)bridge).buildTable();
        JDKSerializationTests.TestPartitionedDataLayer dataLayer = new JDKSerializationTests.TestPartitionedDataLayer(bridge, 4, 32, null, ring, table);
        SSTablesSupplier supplier = dataLayer.sstables(this.partitionId, null, new ArrayList());
        Set ssTableReaders = supplier.openAll((ssTable, isRepairPrimary) -> new MultipleReplicasTests.TestSSTableReader(ssTable));
        Assertions.assertThat((Collection)ssTableReaders).isNotNull();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSSTableSupplierWithMatchingFilters(CassandraBridge bridge) {
        CassandraRing ring = TestUtils.createRing(Partitioner.Murmur3Partitioner, 3);
        CqlTable table = TestSchema.basic((CassandraBridge)bridge).buildTable();
        JDKSerializationTests.TestPartitionedDataLayer dataLayer = new JDKSerializationTests.TestPartitionedDataLayer(bridge, 4, 32, null, ring, table);
        PartitionKeyFilter filter = PartitionKeyFilter.create((ByteBuffer)ByteBuffer.wrap(RandomUtils.nextBytes((int)10)), (BigInteger)BigInteger.valueOf(-9223372036854775807L));
        SSTablesSupplier supplier = dataLayer.sstables(this.partitionId, null, Collections.singletonList(filter));
        Set ssTableReaders = supplier.openAll((ssTable, isRepairPrimary) -> new MultipleReplicasTests.TestSSTableReader(ssTable));
        Assertions.assertThat((Collection)ssTableReaders).isNotNull();
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSSTableSupplierWithNonMatchingFilters(CassandraBridge bridge) {
        CassandraRing ring = TestUtils.createRing(Partitioner.Murmur3Partitioner, 3);
        CqlTable table = TestSchema.basic((CassandraBridge)bridge).buildTable();
        JDKSerializationTests.TestPartitionedDataLayer dataLayer = new JDKSerializationTests.TestPartitionedDataLayer(bridge, 4, 32, null, ring, table);
        PartitionKeyFilter filter = PartitionKeyFilter.create((ByteBuffer)ByteBuffer.wrap(RandomUtils.nextBytes((int)10)), (BigInteger)BigInteger.valueOf(0x5FFFFFFFFFFFFFFDL));
        Assertions.assertThatThrownBy(() -> this.lambda$testSSTableSupplierWithNonMatchingFilters$5((DataLayer)dataLayer, filter)).isInstanceOf(NotEnoughReplicasException.class);
    }

    @Test
    public void testFiltersInRange() throws Exception {
        Map<Integer, Range> reversePartitionMap = Collections.singletonMap(TaskContext.getPartitionId(), Range.openClosed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(2L)));
        TokenPartitioner mockPartitioner = (TokenPartitioner)Mockito.mock(TokenPartitioner.class);
        Mockito.when((Object)mockPartitioner.reversePartitionMap()).thenReturn(reversePartitionMap);
        PartitionedDataLayer dataLayer = (PartitionedDataLayer)Mockito.mock(PartitionedDataLayer.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)dataLayer.tokenPartitioner()).thenReturn((Object)mockPartitioner);
        PartitionKeyFilter filterInRange = PartitionKeyFilter.create((ByteBuffer)ByteBuffer.wrap(new byte[10]), (BigInteger)BigInteger.valueOf(2L));
        PartitionKeyFilter filterOutsideRange = PartitionKeyFilter.create((ByteBuffer)ByteBuffer.wrap(new byte[10]), (BigInteger)BigInteger.TEN);
        PartitionKeyFilter randomFilter = (PartitionKeyFilter)Mockito.mock(PartitionKeyFilter.class);
        Mockito.when((Object)randomFilter.overlaps((TokenRange)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertThat((List)dataLayer.partitionKeyFiltersInRange(this.partitionId, Collections.singletonList(randomFilter))).isNotEmpty();
        Assertions.assertThat((List)dataLayer.partitionKeyFiltersInRange(this.partitionId, Arrays.asList(filterInRange, randomFilter))).hasSize(2);
        Assertions.assertThat((List)dataLayer.partitionKeyFiltersInRange(this.partitionId, Arrays.asList(filterInRange, filterOutsideRange, randomFilter))).hasSize(2);
        StreamScanner scanner = dataLayer.openCompactionScanner(this.partitionId, Collections.singletonList(filterOutsideRange));
        Assertions.assertThat((Object)scanner).isInstanceOf(EmptyStreamScanner.class);
    }

    private static void runSplitTests(int minReplicas, PartitionedDataLayer.AvailabilityHint ... availabilityHint) {
        int numInstances = availabilityHint.length;
        TestUtils.runTest((partitioner, dir, bridge) -> {
            CassandraRing ring = TestUtils.createRing(partitioner, numInstances);
            ArrayList<CassandraInstance> instances = new ArrayList<CassandraInstance>(ring.instances());
            instances.sort(Comparator.comparing(CassandraInstance::nodeName));
            TokenPartitioner tokenPartitioner = new TokenPartitioner(ring, 1, 32);
            HashMap<CassandraInstance, PartitionedDataLayer.AvailabilityHint> availableMap = new HashMap<CassandraInstance, PartitionedDataLayer.AvailabilityHint>(numInstances);
            for (int instance = 0; instance < numInstances; ++instance) {
                availableMap.put((CassandraInstance)instances.get(instance), availabilityHint[instance]);
            }
            Map ranges = ring.getSubRanges(tokenPartitioner.getTokenRange(0)).asMapOfRanges();
            PartitionedDataLayer.ReplicaSet replicaSet = PartitionedDataLayer.splitReplicas(instances, (Map)ranges, availableMap::get, (int)minReplicas, (int)0);
            Assertions.assertThat((Collection)replicaSet.primary()).hasSize(minReplicas);
            Assertions.assertThat((Collection)replicaSet.backup()).hasSize(numInstances - minReplicas);
            ArrayList<CassandraInstance> sortedInstances = new ArrayList<CassandraInstance>(instances);
            sortedInstances.sort(Comparator.comparing(availableMap::get, PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR));
            for (int instance = 0; instance < sortedInstances.size(); ++instance) {
                if (instance < minReplicas) {
                    Assertions.assertThat((Collection)replicaSet.primary()).contains((Object[])new CassandraInstance[]{(CassandraInstance)sortedInstances.get(instance)});
                    continue;
                }
                Assertions.assertThat((Collection)replicaSet.backup()).contains((Object[])new CassandraInstance[]{(CassandraInstance)sortedInstances.get(instance)});
            }
        });
    }

    @Test
    public void testSplitReplicas() {
        ReplicationFactor replicationFactor = TestUtils.networkTopologyStrategy();
        TestUtils.runTest((partitioner, dir, bridge) -> QuickTheory.qt().forAll(Generate.pick(Arrays.asList(3, 32, 1024)), Generate.pick(Arrays.asList(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.ONE, ConsistencyLevel.ALL, ConsistencyLevel.TWO)), Generate.pick(Arrays.asList(1, 32, 1024)), Generate.pick(Arrays.asList(1, 32, 1024))).checkAssert((numInstances, consistencyLevel, numCores, defaultParallelism) -> PartitionedDataLayerTests.testSplitReplicas(TestUtils.createRing(partitioner, numInstances), consistencyLevel, defaultParallelism, numCores, replicationFactor, "DC1")));
    }

    private static void testSplitReplicas(CassandraRing ring, ConsistencyLevel consistencyLevel, int defaultParallelism, int numCores, ReplicationFactor replicationFactor, String dc) {
        TokenPartitioner tokenPartitioner = new TokenPartitioner(ring, defaultParallelism, numCores);
        for (int partition = 0; partition < tokenPartitioner.numPartitions(); ++partition) {
            Range range = tokenPartitioner.getTokenRange(partition);
            Map subRanges = ring.getSubRanges(range).asMapOfRanges();
            Set replicas = PartitionedDataLayer.rangesToReplicas((ConsistencyLevel)consistencyLevel, (String)dc, (Map)subRanges);
            Function<CassandraInstance, PartitionedDataLayer.AvailabilityHint> availability = instances -> PartitionedDataLayer.AvailabilityHint.UP;
            int minReplicas = consistencyLevel.blockFor(replicationFactor, dc);
            PartitionedDataLayer.ReplicaSet replicaSet = PartitionedDataLayer.splitReplicas((ConsistencyLevel)consistencyLevel, (String)dc, (Map)subRanges, (Set)replicas, availability, (int)minReplicas, (int)0);
            Assertions.assertThat((Object)replicaSet).isNotNull();
            Assertions.assertThat((boolean)Collections.disjoint(replicaSet.primary(), replicaSet.backup())).isTrue();
            Assertions.assertThat((int)(replicaSet.primary().size() + replicaSet.backup().size())).isEqualTo(replicas.size());
        }
    }

    @Test
    public void testSortingByAvailabilityHintComparator() {
        int i;
        List<PartitionedDataLayer.AvailabilityHint> hints = Arrays.asList(PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.DOWN);
        for (i = 0; i < 5; ++i) {
            PartitionedDataLayerTests.validateHintsSequence(hints, 1, 3);
        }
        hints = Arrays.asList(PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.DOWN);
        for (i = 0; i < 5; ++i) {
            PartitionedDataLayerTests.validateHintsSequence(hints, 3, 6);
        }
    }

    private static void validateHintsSequence(List<PartitionedDataLayer.AvailabilityHint> hints, int upCount, int movingOrLeavingCount) {
        ArrayList<PartitionedDataLayer.AvailabilityHint> shuffledHints = new ArrayList<PartitionedDataLayer.AvailabilityHint>(hints);
        Collections.shuffle(shuffledHints);
        ArrayList<PartitionedDataLayer.AvailabilityHint> sorted = new ArrayList<PartitionedDataLayer.AvailabilityHint>(shuffledHints);
        sorted.sort(PartitionedDataLayer.AvailabilityHint.AVAILABILITY_HINT_COMPARATOR);
        ((ListAssert)Assertions.assertThat(sorted.subList(0, upCount)).contains((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.UP})).doesNotContain((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.LEAVING, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.JOINING, PartitionedDataLayer.AvailabilityHint.DOWN});
        ((ListAssert)Assertions.assertThat(sorted.subList(upCount, movingOrLeavingCount)).contains((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.LEAVING})).doesNotContain((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.JOINING});
        ((ListAssert)Assertions.assertThat(sorted.subList(movingOrLeavingCount, sorted.size())).contains((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.DOWN, PartitionedDataLayer.AvailabilityHint.UNKNOWN, PartitionedDataLayer.AvailabilityHint.JOINING})).doesNotContain((Object[])new PartitionedDataLayer.AvailabilityHint[]{PartitionedDataLayer.AvailabilityHint.UP, PartitionedDataLayer.AvailabilityHint.MOVING, PartitionedDataLayer.AvailabilityHint.LEAVING});
    }

    private /* synthetic */ void lambda$testSSTableSupplierWithNonMatchingFilters$5(DataLayer dataLayer, PartitionKeyFilter filter) throws Throwable {
        dataLayer.sstables(this.partitionId, null, Collections.singletonList(filter));
    }
}

