/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Collection;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

public class RingInstanceTest {
    public static RingInstance instance(BigInteger token, String nodeName, String datacenter) {
        return RingInstanceTest.instance(token, nodeName, datacenter, null);
    }

    public static RingInstance instance(BigInteger token, String nodeName, String datacenter, String clusterId) {
        return new RingInstance(new RingEntry.Builder().datacenter(datacenter).port(7000).address(nodeName).status("UP").state("NORMAL").token(token.toString()).fqdn(nodeName).rack("rack").owns("").load("").hostId("").build(), clusterId);
    }

    @Test
    public void testEquals() {
        RingInstance instance1 = RingInstanceTest.mockRingInstance();
        RingInstance instance2 = RingInstanceTest.mockRingInstance();
        Assertions.assertThat((Object)instance1).isEqualTo((Object)instance2);
    }

    @Test
    public void testHashCode() {
        RingInstance instance1 = RingInstanceTest.mockRingInstance();
        RingInstance instance2 = RingInstanceTest.mockRingInstance();
        Assertions.assertThat((int)instance1.hashCode()).isEqualTo(instance2.hashCode());
    }

    @Test
    public void testEqualsAndHashcodeIgnoreNonCriticalFields() {
        RingEntry.Builder builder = RingInstanceTest.mockRingEntryBuilder();
        RingInstance instance1 = new RingInstance(builder.status("1").state("1").load("1").hostId("1").owns("1").build());
        RingInstance instance2 = new RingInstance(builder.status("2").state("2").load("2").hostId("2").owns("2").build());
        Assertions.assertThat((Object)instance1).isEqualTo((Object)instance2);
        Assertions.assertThat((int)instance1.hashCode()).isEqualTo(instance2.hashCode());
    }

    @Test
    public void testEqualsAndHashcodeConsidersClusterId() {
        RingEntry ringEntry = RingInstanceTest.mockRingEntry();
        RingInstance c1i1 = new RingInstance(ringEntry, "cluster1");
        RingInstance c1i2 = new RingInstance(ringEntry, "cluster1");
        RingInstance c2i1 = new RingInstance(ringEntry, "cluster2");
        Assertions.assertThat((Object)c1i1).isEqualTo((Object)c1i2);
        Assertions.assertThat((int)c1i1.hashCode()).isEqualTo(c1i2.hashCode());
        Assertions.assertThat((Object)c1i1).isNotEqualTo((Object)c2i1);
        Assertions.assertThat((int)c1i1.hashCode()).isNotEqualTo(c2i1.hashCode());
    }

    @Test
    public void testGetClusterId() {
        RingEntry ringEntry = RingInstanceTest.mockRingEntry();
        RingInstance instance = new RingInstance(ringEntry);
        Assertions.assertThat((String)instance.clusterId()).isNull();
        RingInstance instanceWithClusterId = new RingInstance(ringEntry, "cluster1");
        Assertions.assertThat((String)instanceWithClusterId.clusterId()).isNotNull();
        Assertions.assertThat((String)instanceWithClusterId.clusterId()).isEqualTo("cluster1");
    }

    @Test
    public void multiMapWorksWithRingInstances() {
        RingEntry ringEntry = RingInstanceTest.mockRingEntry();
        RingInstance instance1 = new RingInstance(ringEntry);
        RingInstance instance2 = new RingInstance(ringEntry);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(instance2);
            out.close();
            byte[] buffer = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            ObjectInputStream in = new ObjectInputStream(bais);
            instance2 = (RingInstance)in.readObject();
            in.close();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
        ArrayListMultimap initialErrorMap = ArrayListMultimap.create();
        initialErrorMap.put((Object)instance1, (Object)"Failure 1");
        ArrayListMultimap newErrorMap = ArrayListMultimap.create((Multimap)initialErrorMap);
        newErrorMap.put((Object)instance2, (Object)"Failure2");
        Assertions.assertThat((Collection)newErrorMap.keySet()).hasSize(1);
    }

    @Test
    public void testToString() {
        RingEntry ringEntry = RingInstanceTest.mockRingEntry();
        RingInstance instanceWithoutClusterId = new RingInstance(ringEntry);
        Assertions.assertThat((String)instanceWithoutClusterId.toString()).isEqualTo("RingInstance{cluster='null', RingEntry{datacenter='DATACENTER1', address='127.0.0.1', port=0, rack='Rack', status='UP', state='NORMAL', load='0', owns='', token='0', fqdn='DATACENTER1-i1', hostId=''}}");
        RingInstance instanceWithClusterId = new RingInstance(ringEntry, "clusterId");
        Assertions.assertThat((String)instanceWithClusterId.toString()).isEqualTo("RingInstance{cluster='clusterId', RingEntry{datacenter='DATACENTER1', address='127.0.0.1', port=0, rack='Rack', status='UP', state='NORMAL', load='0', owns='', token='0', fqdn='DATACENTER1-i1', hostId=''}}");
    }

    @NotNull
    private static RingEntry mockRingEntry() {
        return RingInstanceTest.mockRingEntryBuilder().build();
    }

    @NotNull
    private static RingEntry.Builder mockRingEntryBuilder() {
        return new RingEntry.Builder().datacenter("DATACENTER1").address("127.0.0.1").port(0).rack("Rack").status("UP").state("NORMAL").load("0").token("0").fqdn("DATACENTER1-i1").hostId("").owns("");
    }

    @NotNull
    private static RingInstance mockRingInstance() {
        return new RingInstance(RingInstanceTest.mockRingEntry());
    }
}

