/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.spark.bulkwriter.DecoratedKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DecoratedKeyTest {
    @Test
    public void compareToBytesDifferent() {
        DecoratedKey key1 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97, 97}));
        DecoratedKey key2 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97, 122}));
        Assertions.assertThat((int)key2.compareTo(key1)).isNotEqualTo(0);
    }

    @Test
    public void compareToBytesDifferentLengths() {
        DecoratedKey key1 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97}));
        DecoratedKey key2 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97, 97}));
        Assertions.assertThat((int)key2.compareTo(key1)).isNotEqualTo(0);
    }

    @Test
    public void compareToTokensDifferent() {
        DecoratedKey key1 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97}));
        DecoratedKey key2 = new DecoratedKey(BigInteger.valueOf(2L), ByteBuffer.wrap(new byte[]{97}));
        Assertions.assertThat((int)key1.compareTo(key2)).isNotEqualTo(0);
    }

    @Test
    public void equals() {
        DecoratedKey key1 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97}));
        DecoratedKey key2 = new DecoratedKey(BigInteger.valueOf(1L), ByteBuffer.wrap(new byte[]{97}));
        Assertions.assertThat((Comparable)key1).isEqualTo((Object)key2);
    }
}

