/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.ToLongFunction;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.metrics.TableMetrics;

public class KeyspaceMetrics {
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> memtableOnHeapDataSize;
    public final Gauge<Long> memtableOffHeapDataSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapDataSize;
    public final Gauge<Long> allMemtablesOffHeapDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Gauge<Long> memtableSwitchCount;
    public final Gauge<Long> pendingFlushes;
    public final Gauge<Long> pendingCompactions;
    public final Gauge<Long> liveDiskSpaceUsed;
    public final Gauge<Long> totalDiskSpaceUsed;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Long> bloomFilterOffHeapMemoryUsed;
    public final Gauge<Long> indexSummaryOffHeapMemoryUsed;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Histogram sstablesPerReadHistogram;
    public final Histogram tombstoneScannedHistogram;
    public final Histogram liveScannedHistogram;
    public final Histogram colUpdateTimeDeltaHistogram;
    public final Timer viewLockAcquireTime;
    public final Timer viewReadTime;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Counter writeFailedIdealCL;
    public final LatencyMetrics idealCLWriteLatency;
    public final Counter speculativeRetries;
    public final Counter speculativeFailedRetries;
    public final Counter speculativeInsufficientReplicas;
    public final Counter additionalWrites;
    public final Counter repairsStarted;
    public final Counter repairsCompleted;
    public final Timer repairTime;
    public final Timer repairPrepareTime;
    public final Timer anticompactionTime;
    public final Timer validationTime;
    public final Timer repairSyncTime;
    public final Histogram bytesValidated;
    public final Histogram partitionsValidated;
    public final Counter outOfRangeTokenReads;
    public final Counter outOfRangeTokenWrites;
    public final Counter outOfRangeTokenPaxosRequests;
    public final Meter confirmedRepairedInconsistencies;
    public final Meter unconfirmedRepairedInconsistencies;
    public final Histogram repairedDataTrackingOverreadRows;
    public final Timer repairedDataTrackingOverreadTime;
    public final MetricNameFactory factory;
    private Keyspace keyspace;
    private Set<TableMetrics.ReleasableMetric> allMetrics = Sets.newHashSet();

    public KeyspaceMetrics(Keyspace ks) {
        this.factory = new KeyspaceMetricNameFactory(ks);
        this.keyspace = ks;
        this.memtableColumnsCount = this.createKeyspaceGauge("MemtableColumnsCount", metric -> (Long)metric.memtableColumnsCount.getValue());
        this.memtableLiveDataSize = this.createKeyspaceGauge("MemtableLiveDataSize", metric -> (Long)metric.memtableLiveDataSize.getValue());
        this.memtableOnHeapDataSize = this.createKeyspaceGauge("MemtableOnHeapDataSize", metric -> (Long)metric.memtableOnHeapDataSize.getValue());
        this.memtableOffHeapDataSize = this.createKeyspaceGauge("MemtableOffHeapDataSize", metric -> (Long)metric.memtableOffHeapDataSize.getValue());
        this.allMemtablesLiveDataSize = this.createKeyspaceGauge("AllMemtablesLiveDataSize", metric -> (Long)metric.allMemtablesLiveDataSize.getValue());
        this.allMemtablesOnHeapDataSize = this.createKeyspaceGauge("AllMemtablesOnHeapDataSize", metric -> (Long)metric.allMemtablesOnHeapDataSize.getValue());
        this.allMemtablesOffHeapDataSize = this.createKeyspaceGauge("AllMemtablesOffHeapDataSize", metric -> (Long)metric.allMemtablesOffHeapDataSize.getValue());
        this.memtableSwitchCount = this.createKeyspaceGauge("MemtableSwitchCount", metric -> metric.memtableSwitchCount.getCount());
        this.pendingCompactions = this.createKeyspaceGauge("PendingCompactions", metric -> ((Integer)metric.pendingCompactions.getValue()).intValue());
        this.pendingFlushes = this.createKeyspaceGauge("PendingFlushes", metric -> metric.pendingFlushes.getCount());
        this.liveDiskSpaceUsed = this.createKeyspaceGauge("LiveDiskSpaceUsed", metric -> metric.liveDiskSpaceUsed.getCount());
        this.totalDiskSpaceUsed = this.createKeyspaceGauge("TotalDiskSpaceUsed", metric -> metric.totalDiskSpaceUsed.getCount());
        this.bloomFilterDiskSpaceUsed = this.createKeyspaceGauge("BloomFilterDiskSpaceUsed", metric -> (Long)metric.bloomFilterDiskSpaceUsed.getValue());
        this.bloomFilterOffHeapMemoryUsed = this.createKeyspaceGauge("BloomFilterOffHeapMemoryUsed", metric -> (Long)metric.bloomFilterOffHeapMemoryUsed.getValue());
        this.indexSummaryOffHeapMemoryUsed = this.createKeyspaceGauge("IndexSummaryOffHeapMemoryUsed", metric -> (Long)metric.indexSummaryOffHeapMemoryUsed.getValue());
        this.compressionMetadataOffHeapMemoryUsed = this.createKeyspaceGauge("CompressionMetadataOffHeapMemoryUsed", metric -> (Long)metric.compressionMetadataOffHeapMemoryUsed.getValue());
        this.readLatency = this.createLatencyMetrics("Read");
        this.writeLatency = this.createLatencyMetrics("Write");
        this.rangeLatency = this.createLatencyMetrics("Range");
        this.sstablesPerReadHistogram = this.createKeyspaceHistogram("SSTablesPerReadHistogram", true);
        this.tombstoneScannedHistogram = this.createKeyspaceHistogram("TombstoneScannedHistogram", false);
        this.liveScannedHistogram = this.createKeyspaceHistogram("LiveScannedHistogram", false);
        this.colUpdateTimeDeltaHistogram = this.createKeyspaceHistogram("ColUpdateTimeDeltaHistogram", false);
        this.viewLockAcquireTime = this.createKeyspaceTimer("ViewLockAcquireTime");
        this.viewReadTime = this.createKeyspaceTimer("ViewReadTime");
        this.casPrepare = this.createLatencyMetrics("CasPrepare");
        this.casPropose = this.createLatencyMetrics("CasPropose");
        this.casCommit = this.createLatencyMetrics("CasCommit");
        this.writeFailedIdealCL = this.createKeyspaceCounter("WriteFailedIdealCL");
        this.idealCLWriteLatency = this.createLatencyMetrics("IdealCLWrite");
        this.speculativeRetries = this.createKeyspaceCounter("SpeculativeRetries", metric -> metric.speculativeRetries.getCount());
        this.speculativeFailedRetries = this.createKeyspaceCounter("SpeculativeFailedRetries", metric -> metric.speculativeFailedRetries.getCount());
        this.speculativeInsufficientReplicas = this.createKeyspaceCounter("SpeculativeInsufficientReplicas", metric -> metric.speculativeInsufficientReplicas.getCount());
        this.additionalWrites = this.createKeyspaceCounter("AdditionalWrites", metric -> metric.additionalWrites.getCount());
        this.repairsStarted = this.createKeyspaceCounter("RepairJobsStarted", metric -> metric.repairsStarted.getCount());
        this.repairsCompleted = this.createKeyspaceCounter("RepairJobsCompleted", metric -> metric.repairsCompleted.getCount());
        this.repairTime = this.createKeyspaceTimer("RepairTime");
        this.repairPrepareTime = this.createKeyspaceTimer("RepairPrepareTime");
        this.anticompactionTime = this.createKeyspaceTimer("AntiCompactionTime");
        this.validationTime = this.createKeyspaceTimer("ValidationTime");
        this.repairSyncTime = this.createKeyspaceTimer("RepairSyncTime");
        this.partitionsValidated = this.createKeyspaceHistogram("PartitionsValidated", false);
        this.bytesValidated = this.createKeyspaceHistogram("BytesValidated", false);
        this.confirmedRepairedInconsistencies = this.createKeyspaceMeter("RepairedDataInconsistenciesConfirmed");
        this.unconfirmedRepairedInconsistencies = this.createKeyspaceMeter("RepairedDataInconsistenciesUnconfirmed");
        this.repairedDataTrackingOverreadRows = this.createKeyspaceHistogram("RepairedDataTrackingOverreadRows", false);
        this.repairedDataTrackingOverreadTime = this.createKeyspaceTimer("RepairedDataTrackingOverreadTime");
        this.outOfRangeTokenReads = this.createKeyspaceCounter("ReadOutOfRangeToken");
        this.outOfRangeTokenWrites = this.createKeyspaceCounter("WriteOutOfRangeToken");
        this.outOfRangeTokenPaxosRequests = this.createKeyspaceCounter("PaxosOutOfRangeToken");
    }

    public void release() {
        for (TableMetrics.ReleasableMetric metric : this.allMetrics) {
            metric.release();
        }
    }

    private Gauge<Long> createKeyspaceGauge(String name, final ToLongFunction<TableMetrics> extractor) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                for (ColumnFamilyStore cf : KeyspaceMetrics.this.keyspace.getColumnFamilyStores()) {
                    sum += extractor.applyAsLong(cf.metric);
                }
                return sum;
            }
        });
    }

    private Counter createKeyspaceCounter(String name, final ToLongFunction<TableMetrics> extractor) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), new Counter(){

            public long getCount() {
                long sum = 0L;
                for (ColumnFamilyStore cf : KeyspaceMetrics.this.keyspace.getColumnFamilyStores()) {
                    sum += extractor.applyAsLong(cf.metric);
                }
                return sum;
            }
        });
    }

    protected Counter createKeyspaceCounter(String name) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(name));
    }

    protected Histogram createKeyspaceHistogram(String name, boolean considerZeroes) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name), considerZeroes);
    }

    protected Timer createKeyspaceTimer(String name) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName(name));
    }

    protected Meter createKeyspaceMeter(String name) {
        this.allMetrics.add(() -> this.releaseMetric(name));
        return CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName(name));
    }

    private LatencyMetrics createLatencyMetrics(String name) {
        LatencyMetrics metric = new LatencyMetrics(this.factory, name);
        this.allMetrics.add(() -> metric.release());
        return metric;
    }

    private void releaseMetric(String name) {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(name));
    }

    static class KeyspaceMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;

        KeyspaceMetricNameFactory(Keyspace ks) {
            this.keyspaceName = ks.getName();
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = TableMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=Keyspace");
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, "keyspace", metricName, this.keyspaceName, mbeanName.toString());
        }
    }
}

