/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.ssl;

import com.datastax.shaded.netty.buffer.ByteBufAllocator;
import com.datastax.shaded.netty.handler.ssl.ApplicationProtocolConfig;
import com.datastax.shaded.netty.handler.ssl.CipherSuiteFilter;
import com.datastax.shaded.netty.handler.ssl.ClientAuth;
import com.datastax.shaded.netty.handler.ssl.OpenSsl;
import com.datastax.shaded.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.datastax.shaded.netty.handler.ssl.OpenSslEngine;
import com.datastax.shaded.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.datastax.shaded.netty.handler.ssl.SslContextOption;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public abstract class OpenSslContext
extends ReferenceCountedOpenSslContext {
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, OpenSslContext.toNegotiator(apnCfg), mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, String[] protocols, boolean startTls, boolean enableOcsp, Map.Entry<SslContextOption<?>, Object> ... options) throws SSLException {
        super(ciphers, cipherFilter, apn, mode, keyCertChain, clientAuth, protocols, startTls, enableOcsp, false, options);
    }

    @Override
    final SSLEngine newEngine0(ByteBufAllocator alloc, String peerHost, int peerPort, boolean jdkCompatibilityMode) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort, jdkCompatibilityMode);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        OpenSsl.releaseIfNeeded(this);
    }
}

