/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregatorFactory;

class ThreadStateAggregatorFactory
implements ThreadDumpAggregator,
ThreadDumpAggregatorFactory {
    private final Thread.State state;
    long total;
    long matched;

    public ThreadStateAggregatorFactory(Thread.State state) {
        this.state = state;
    }

    @Override
    public ThreadDumpAggregator newInstance() {
        return new ThreadStateAggregatorFactory(this.state);
    }

    @Override
    public void aggregate(ThreadSnapshot threadInfo) {
        ++this.total;
        if (threadInfo.threadState() == this.state) {
            ++this.matched;
        }
    }

    @Override
    public Object info() {
        return (double)this.matched / (double)this.total;
    }
}

