/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.activemq.broker.util.AuditLogEntry;
import org.apache.activemq.broker.util.AuditLogService;
import org.apache.activemq.web.HttpAuditLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.activemq.audit");
    private boolean audit;
    private AuditLogService auditLog;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.audit = "true".equalsIgnoreCase(System.getProperty("org.apache.activemq.audit"));
        if (this.audit) {
            this.auditLog = AuditLogService.getAuditLog();
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.audit && request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            HttpAuditLogEntry entry = new HttpAuditLogEntry();
            if (http.getRemoteUser() != null) {
                entry.setUser(http.getRemoteUser());
            }
            entry.setTimestamp(System.currentTimeMillis());
            entry.setOperation(http.getRequestURI());
            entry.setRemoteAddr(http.getRemoteAddr());
            entry.getParameters().put("params", http.getParameterMap());
            this.auditLog.log((AuditLogEntry)entry);
        }
        chain.doFilter(request, response);
    }
}

