/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectVmBlockingProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectVmBlockingProducer.class);
    private final DirectVmEndpoint endpoint;

    public DirectVmBlockingProducer(DirectVmEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.getConsumer(exchange).getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.getConsumer(exchange).getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected DirectVmConsumer getConsumer(Exchange exchange) throws Exception {
        DirectVmConsumer answer = this.endpoint.getConsumer();
        if (answer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
            answer = this.awaitConsumer();
            if (answer == null) {
                throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
        }
        return answer;
    }

    private DirectVmConsumer awaitConsumer() throws InterruptedException {
        DirectVmConsumer answer = null;
        StopWatch watch = new StopWatch();
        boolean done = false;
        while (!done) {
            Thread.sleep(500L);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waited {} for consumer to be ready", (Object)watch.taken());
            }
            if ((answer = this.endpoint.getConsumer()) != null) {
                return answer;
            }
            done = watch.taken() >= this.endpoint.getTimeout();
        }
        return answer;
    }
}

