/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;

public class ClasspathCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) {
        PrintWriter writer = shellState.getWriter();
        ClasspathCommand.printClassPath(writer);
        return 0;
    }

    @Override
    public String description() {
        return "lists the current files on the classpath";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    public static void printClassPath(PrintWriter writer) {
        writer.println("Accumulo Shell Classpath:");
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath == null) {
            throw new IllegalStateException("java.class.path is not set");
        }
        Arrays.stream(javaClassPath.split(File.pathSeparator)).forEach(writer::println);
        writer.println();
    }
}

