/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.threads;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.threads.NamedThreadFactory;
import org.apache.accumulo.core.util.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RV_EXCEPTION_NOT_THROWN"}, justification="Throwing Error for it to be caught by AccumuloUncaughtExceptionHandler")
public class ThreadPools {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPools.class);
    public static final long DEFAULT_TIMEOUT_MILLISECS = 180000L;
    private static final ThreadPools SERVER_INSTANCE = new ThreadPools(Threads.UEH);
    private static final ThreadPoolExecutor SCHEDULED_FUTURE_CHECKER_POOL = ThreadPools.getServerThreadPools().createFixedThreadPool(1, "Scheduled Future Checker", false);
    private static final ConcurrentLinkedQueue<ScheduledFuture<?>> CRITICAL_RUNNING_TASKS = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<ScheduledFuture<?>> NON_CRITICAL_RUNNING_TASKS = new ConcurrentLinkedQueue();
    private static Runnable TASK_CHECKER = () -> {
        List<ConcurrentLinkedQueue<ScheduledFuture<?>>> queues = List.of(CRITICAL_RUNNING_TASKS, NON_CRITICAL_RUNNING_TASKS);
        while (true) {
            queues.forEach(q -> {
                Iterator tasks = q.iterator();
                while (tasks.hasNext()) {
                    if (!ThreadPools.checkTaskFailed((ScheduledFuture)tasks.next(), q)) continue;
                    tasks.remove();
                }
            });
            try {
                TimeUnit.MINUTES.sleep(1L);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    };
    private final Thread.UncaughtExceptionHandler handler;

    public static final ThreadPools getServerThreadPools() {
        return SERVER_INSTANCE;
    }

    public static final ThreadPools getClientThreadPools(Thread.UncaughtExceptionHandler ueh) {
        return new ThreadPools(ueh);
    }

    private static boolean checkTaskFailed(ScheduledFuture<?> future, ConcurrentLinkedQueue<ScheduledFuture<?>> taskQueue) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException ee) {
                if (taskQueue == CRITICAL_RUNNING_TASKS) {
                    throw new ExecutionError("Critical scheduled background task failed.", ee);
                }
                LOG.error("Non-critical scheduled background task failed", (Throwable)ee);
                return true;
            }
            catch (CancellationException ce) {
                return true;
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted while waiting to check on scheduled background task.");
                Thread.interrupted();
            }
        }
        return false;
    }

    public static void watchCriticalScheduledTask(ScheduledFuture<?> future) {
        CRITICAL_RUNNING_TASKS.add(future);
    }

    public static void watchCriticalFixedDelay(AccumuloConfiguration aconf, long intervalMillis, Runnable runnable) {
        ScheduledFuture<?> future = ThreadPools.getServerThreadPools().createGeneralScheduledExecutorService(aconf).scheduleWithFixedDelay(runnable, intervalMillis, intervalMillis, TimeUnit.MILLISECONDS);
        CRITICAL_RUNNING_TASKS.add(future);
    }

    public static void watchNonCriticalScheduledTask(ScheduledFuture<?> future) {
        NON_CRITICAL_RUNNING_TASKS.add(future);
    }

    public static void ensureRunning(ScheduledFuture<?> future, String message) {
        if (future.isDone()) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new IllegalStateException(message, e);
            }
            throw new IllegalStateException(message);
        }
    }

    public static void resizePool(ThreadPoolExecutor pool, IntSupplier maxThreads, String poolName) {
        int newCount;
        int count = pool.getMaximumPoolSize();
        if (count == (newCount = maxThreads.getAsInt())) {
            return;
        }
        LOG.info("Changing max threads for {} from {} to {}", new Object[]{poolName, count, newCount});
        if (newCount > count) {
            pool.setMaximumPoolSize(newCount);
            pool.setCorePoolSize(newCount);
        } else {
            pool.setCorePoolSize(newCount);
            pool.setMaximumPoolSize(newCount);
        }
    }

    public static void resizePool(ThreadPoolExecutor pool, AccumuloConfiguration conf, Property p) {
        ThreadPools.resizePool(pool, () -> conf.getCount(p), p.getKey());
    }

    private ThreadPools(Thread.UncaughtExceptionHandler ueh) {
        this.handler = ueh;
    }

    public ThreadPoolExecutor createExecutorService(AccumuloConfiguration conf, Property p, boolean emitThreadPoolMetrics) {
        switch (p) {
            case GENERAL_THREADPOOL_SIZE: {
                return this.createScheduledExecutorService(conf.getCount(p), "GeneralExecutor", emitThreadPoolMetrics);
            }
            case MANAGER_FATE_THREADPOOL_SIZE: {
                return this.createFixedThreadPool(conf.getCount(p), "Repo Runner", emitThreadPoolMetrics);
            }
            case MANAGER_STATUS_THREAD_POOL_SIZE: {
                int threads = conf.getCount(p);
                if (threads == 0) {
                    return this.createThreadPool(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, "GatherTableInformation", new SynchronousQueue<Runnable>(), emitThreadPoolMetrics);
                }
                return this.createFixedThreadPool(threads, "GatherTableInformation", emitThreadPoolMetrics);
            }
            case TSERV_WORKQ_THREADS: {
                return this.createFixedThreadPool(conf.getCount(p), "distributed work queue", emitThreadPoolMetrics);
            }
            case TSERV_MINC_MAXCONCURRENT: {
                return this.createFixedThreadPool(conf.getCount(p), 0L, TimeUnit.MILLISECONDS, "minor compactor", emitThreadPoolMetrics);
            }
            case TSERV_MIGRATE_MAXCONCURRENT: {
                return this.createFixedThreadPool(conf.getCount(p), 0L, TimeUnit.MILLISECONDS, "tablet migration", emitThreadPoolMetrics);
            }
            case TSERV_ASSIGNMENT_MAXCONCURRENT: {
                return this.createFixedThreadPool(conf.getCount(p), 0L, TimeUnit.MILLISECONDS, "tablet assignment", emitThreadPoolMetrics);
            }
            case TSERV_SUMMARY_RETRIEVAL_THREADS: {
                return this.createThreadPool(conf.getCount(p), conf.getCount(p), 60L, TimeUnit.SECONDS, "summary file retriever", emitThreadPoolMetrics);
            }
            case TSERV_SUMMARY_REMOTE_THREADS: {
                return this.createThreadPool(conf.getCount(p), conf.getCount(p), 60L, TimeUnit.SECONDS, "summary remote", emitThreadPoolMetrics);
            }
            case TSERV_SUMMARY_PARTITION_THREADS: {
                return this.createThreadPool(conf.getCount(p), conf.getCount(p), 60L, TimeUnit.SECONDS, "summary partition", emitThreadPoolMetrics);
            }
            case GC_DELETE_THREADS: {
                return this.createFixedThreadPool(conf.getCount(p), "deleting", emitThreadPoolMetrics);
            }
        }
        throw new IllegalArgumentException("Unhandled thread pool property: " + p);
    }

    public ThreadPoolExecutor createFixedThreadPool(int numThreads, String name, boolean emitThreadPoolMetrics) {
        return this.createFixedThreadPool(numThreads, 180000L, TimeUnit.MILLISECONDS, name, emitThreadPoolMetrics);
    }

    public ThreadPoolExecutor createFixedThreadPool(int numThreads, String name, BlockingQueue<Runnable> queue, boolean emitThreadPoolMetrics) {
        return this.createThreadPool(numThreads, numThreads, 180000L, TimeUnit.MILLISECONDS, name, queue, emitThreadPoolMetrics);
    }

    public ThreadPoolExecutor createFixedThreadPool(int numThreads, long timeOut, TimeUnit units, String name, boolean emitThreadPoolMetrics) {
        return this.createThreadPool(numThreads, numThreads, timeOut, units, name, emitThreadPoolMetrics);
    }

    public ThreadPoolExecutor createThreadPool(int coreThreads, int maxThreads, long timeOut, TimeUnit units, String name, boolean emitThreadPoolMetrics) {
        return this.createThreadPool(coreThreads, maxThreads, timeOut, units, name, new LinkedBlockingQueue<Runnable>(), emitThreadPoolMetrics);
    }

    public ThreadPoolExecutor createThreadPool(int coreThreads, int maxThreads, long timeOut, TimeUnit units, String name, BlockingQueue<Runnable> queue, boolean emitThreadPoolMetrics) {
        return this.createThreadPool(coreThreads, maxThreads, timeOut, units, name, queue, OptionalInt.empty(), emitThreadPoolMetrics);
    }

    public ThreadPoolExecutor createThreadPool(int coreThreads, int maxThreads, long timeOut, TimeUnit units, String name, BlockingQueue<Runnable> queue, OptionalInt priority, boolean emitThreadPoolMetrics) {
        LOG.trace("Creating ThreadPoolExecutor for {} with {} core threads and {} max threads {} {} timeout", new Object[]{name, coreThreads, maxThreads, timeOut, units});
        ThreadPoolExecutor result = new ThreadPoolExecutor(coreThreads, maxThreads, timeOut, units, queue, new NamedThreadFactory(name, priority, this.handler)){

            @Override
            public void execute(Runnable arg0) {
                super.execute(TraceUtil.wrap(arg0));
            }

            @Override
            public boolean remove(Runnable task) {
                return super.remove(TraceUtil.wrap(task));
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return super.submit(TraceUtil.wrap(task));
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return super.submit(TraceUtil.wrap(task), result);
            }

            @Override
            public Future<?> submit(Runnable task) {
                return super.submit(TraceUtil.wrap(task));
            }
        };
        if (timeOut > 0L) {
            result.allowCoreThreadTimeOut(true);
        }
        if (emitThreadPoolMetrics) {
            MetricsUtil.addExecutorServiceMetrics(result, name);
        }
        return result;
    }

    public ScheduledThreadPoolExecutor createGeneralScheduledExecutorService(AccumuloConfiguration conf) {
        return (ScheduledThreadPoolExecutor)this.createExecutorService(conf, Property.GENERAL_THREADPOOL_SIZE, true);
    }

    public ScheduledThreadPoolExecutor createScheduledExecutorService(int numThreads, String name, boolean emitThreadPoolMetrics) {
        LOG.trace("Creating ScheduledThreadPoolExecutor for {} with {} threads", (Object)name, (Object)numThreads);
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(numThreads, new NamedThreadFactory(name, this.handler)){

            @Override
            public void execute(Runnable command) {
                super.execute(TraceUtil.wrap(command));
            }

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
                return super.schedule(TraceUtil.wrap(callable), delay, unit);
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                return super.schedule(TraceUtil.wrap(command), delay, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                return super.scheduleAtFixedRate(TraceUtil.wrap(command), initialDelay, period, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                return super.scheduleWithFixedDelay(TraceUtil.wrap(command), initialDelay, delay, unit);
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return super.submit(TraceUtil.wrap(task));
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return super.submit(TraceUtil.wrap(task), result);
            }

            @Override
            public Future<?> submit(Runnable task) {
                return super.submit(TraceUtil.wrap(task));
            }

            @Override
            public boolean remove(Runnable task) {
                return super.remove(TraceUtil.wrap(task));
            }
        };
        if (emitThreadPoolMetrics) {
            MetricsUtil.addExecutorServiceMetrics(result, name);
        }
        return result;
    }

    static {
        SCHEDULED_FUTURE_CHECKER_POOL.execute(TASK_CHECKER);
    }

    public static class ExecutionError
    extends Error {
        private static final long serialVersionUID = 1L;

        public ExecutionError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

