/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);

    public static HostAndPort parseAddress(String address, boolean ignoreMissingPort) throws NumberFormatException {
        address = address.replace('+', ':');
        HostAndPort hap = HostAndPort.fromString((String)address);
        if (!ignoreMissingPort && !hap.hasPort()) {
            throw new IllegalArgumentException("Address was expected to contain port. address=" + address);
        }
        return hap;
    }

    public static HostAndPort parseAddress(String address, int defaultPort) {
        return AddressUtil.parseAddress(address, true).withDefaultPort(defaultPort);
    }

    public static int getAddressCacheNegativeTtl(UnknownHostException originalException) {
        int negativeTtl = 10;
        try {
            negativeTtl = Integer.parseInt(Security.getProperty("networkaddress.cache.negative.ttl"));
        }
        catch (NumberFormatException exception) {
            log.warn("Failed to get JVM negative DNS response cache TTL due to format problem (e.g. this JVM might not have the property). Falling back to default based on Oracle JVM 1.4+ (10s)", (Throwable)exception);
        }
        catch (SecurityException exception) {
            log.warn("Failed to get JVM negative DNS response cache TTL due to security manager. Falling back to default based on Oracle JVM 1.4+ (10s)", (Throwable)exception);
        }
        if (negativeTtl == -1) {
            log.error("JVM negative DNS response cache TTL is set to 'forever' and host lookup failed. TTL can be changed with security property 'networkaddress.cache.negative.ttl', see java.net.InetAddress.", (Throwable)originalException);
            throw new IllegalArgumentException(originalException);
        }
        if (negativeTtl < 0) {
            log.warn("JVM specified negative DNS response cache TTL was negative (and not 'forever'). Falling back to default based on Oracle JVM 1.4+ (10s)");
            negativeTtl = 10;
        }
        return negativeTtl;
    }
}

