/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.summary.SummarizerConfigurationUtil;
import org.apache.accumulo.core.summary.SummarizerFactory;
import org.apache.accumulo.core.summary.SummarySerializer;
import org.apache.hadoop.io.WritableUtils;

public class SummaryWriter
implements FileSKVWriter {
    static final String METASTORE_PREFIX = "accumulo.summaries";
    static final String METASTORE_INDEX = "accumulo.summaries.index";
    static long MAGIC = 1579118869325171785L;
    static byte VER = 1;
    private FileSKVWriter writer;
    private SummarySerializer.Builder[] summaryStores;

    private SummaryWriter(FileSKVWriter writer, SummarizerFactory factory, List<SummarizerConfiguration> configs, long maxSize) {
        this.writer = writer;
        int i = 0;
        this.summaryStores = new SummarySerializer.Builder[configs.size()];
        for (SummarizerConfiguration sconf : configs) {
            this.summaryStores[i++] = SummarySerializer.builder(sconf, factory, maxSize);
        }
    }

    @Override
    public boolean supportsLocalityGroups() {
        return true;
    }

    @Override
    public void startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
        for (SummarySerializer.Builder ssb : this.summaryStores) {
            ssb.startNewLocalityGroup(name);
        }
        this.writer.startNewLocalityGroup(name, columnFamilies);
    }

    @Override
    public void startDefaultLocalityGroup() throws IOException {
        for (SummarySerializer.Builder ssb : this.summaryStores) {
            ssb.startDefaultLocalityGroup();
        }
        this.writer.startDefaultLocalityGroup();
    }

    @Override
    public void append(Key key, Value value) throws IOException {
        this.writer.append(key, value);
        for (SummarySerializer.Builder ssb : this.summaryStores) {
            ssb.put(key, value);
        }
    }

    @Override
    public DataOutputStream createMetaStore(String name) throws IOException {
        return this.writer.createMetaStore(name);
    }

    public void writeConfig(SummarizerConfiguration conf, DataOutputStream dos) throws IOException {
        dos.writeUTF(conf.getClassName());
        dos.writeUTF(conf.getPropertyId());
        WritableUtils.writeVInt((DataOutput)dos, (int)conf.getOptions().size());
        for (Map.Entry<String, String> entry : conf.getOptions().entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeUTF(entry.getValue());
        }
    }

    @Override
    public void close() throws IOException {
        int i;
        DataOutputStream out = this.writer.createMetaStore(METASTORE_INDEX);
        out.writeLong(MAGIC);
        out.write(VER);
        WritableUtils.writeVInt((DataOutput)out, (int)this.summaryStores.length);
        for (i = 0; i < this.summaryStores.length; ++i) {
            this.writeConfig(this.summaryStores[i].getSummarizerConfiguration(), out);
            out.writeBoolean(false);
            WritableUtils.writeVInt((DataOutput)out, (int)i);
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        }
        out.close();
        for (i = 0; i < this.summaryStores.length; ++i) {
            DataOutputStream summaryOut = this.writer.createMetaStore("accumulo.summaries." + i);
            this.summaryStores[i].save(summaryOut);
            summaryOut.close();
        }
        this.writer.close();
    }

    @Override
    public long getLength() throws IOException {
        return this.writer.getLength();
    }

    public static FileSKVWriter wrap(FileSKVWriter writer, AccumuloConfiguration tableConfig, boolean useAccumuloStart) {
        List<SummarizerConfiguration> configs = SummarizerConfigurationUtil.getSummarizerConfigs(tableConfig);
        if (configs.isEmpty()) {
            return writer;
        }
        SummarizerFactory factory = useAccumuloStart ? new SummarizerFactory(tableConfig) : new SummarizerFactory();
        long maxSize = tableConfig.getAsBytes(Property.TABLE_FILE_SUMMARY_MAX_SIZE);
        return new SummaryWriter(writer, factory, configs, maxSize);
    }
}

