/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.crypto;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerTableCryptoServiceFactory
implements CryptoServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(PerTableCryptoServiceFactory.class);
    private final ConcurrentHashMap<TableId, CryptoService> cryptoServiceMap = new ConcurrentHashMap();
    public static final String WAL_NAME_PROP = Property.GENERAL_ARBITRARY_PROP_PREFIX + "crypto.wal.service";
    public static final String RECOVERY_NAME_PROP = Property.GENERAL_ARBITRARY_PROP_PREFIX + "crypto.recovery.service";
    public static final String TABLE_SERVICE_NAME_PROP = Property.TABLE_CRYPTO_PREFIX + "service";
    private static final TableId WAL_FAKE_ID = TableId.of("WAL_CryptoService_FAKE_ID");
    private static final TableId REC_FAKE_ID = TableId.of("RECOVERY_CryptoService_FAKE_ID");

    @Override
    public CryptoService getService(CryptoEnvironment environment, Map<String, String> props) {
        if (environment.getScope() == CryptoEnvironment.Scope.WAL) {
            return this.cryptoServiceMap.computeIfAbsent(WAL_FAKE_ID, id -> this.getWALServiceInitialized(props));
        }
        if (environment.getScope() == CryptoEnvironment.Scope.RECOVERY) {
            return this.cryptoServiceMap.computeIfAbsent(REC_FAKE_ID, id -> this.getRecoveryServiceInitialized(props));
        }
        if (environment.getTableId().isEmpty()) {
            log.debug("No tableId present in crypto env: " + environment);
            return NoCryptoServiceFactory.NONE;
        }
        TableId tableId = environment.getTableId().orElseThrow();
        if (props == null || props.isEmpty() || props.get(TABLE_SERVICE_NAME_PROP) == null) {
            return NoCryptoServiceFactory.NONE;
        }
        if (environment.getScope() == CryptoEnvironment.Scope.TABLE) {
            return this.cryptoServiceMap.computeIfAbsent(tableId, id -> this.getTableServiceInitialized(tableId, props));
        }
        throw new IllegalStateException("Invalid config for crypto " + environment + " " + props);
    }

    private CryptoService getWALServiceInitialized(Map<String, String> props) {
        String name = Objects.requireNonNull(props.get(WAL_NAME_PROP), "The property " + WAL_NAME_PROP + " is required for encrypting WALs.");
        log.debug("New CryptoService for WAL scope {}={}", (Object)WAL_NAME_PROP, (Object)name);
        CryptoService cs = this.newCryptoService(name);
        cs.init(props);
        return cs;
    }

    private CryptoService getRecoveryServiceInitialized(Map<String, String> props) {
        String name = Objects.requireNonNull(props.get(RECOVERY_NAME_PROP), "The property " + RECOVERY_NAME_PROP + " is required for encrypting during recovery.");
        log.debug("New CryptoService for Recovery scope {}={}", (Object)RECOVERY_NAME_PROP, (Object)name);
        CryptoService cs = this.newCryptoService(name);
        cs.init(props);
        return cs;
    }

    private CryptoService getTableServiceInitialized(TableId tableId, Map<String, String> props) {
        String name = Objects.requireNonNull(props.get(TABLE_SERVICE_NAME_PROP), "The property " + TABLE_SERVICE_NAME_PROP + " is required for encrypting tables.");
        log.debug("New CryptoService for TABLE({}) {}={}", new Object[]{tableId, TABLE_SERVICE_NAME_PROP, name});
        CryptoService cs = this.newCryptoService(name);
        cs.init(props);
        return cs;
    }

    public int getCount() {
        return this.cryptoServiceMap.size();
    }
}

