/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityParseException;

public class VisibilityEvaluator {
    private AuthorizationContainer auths;

    static ByteSequence unescape(ByteSequence auth) {
        int escapeCharCount = 0;
        for (int i = 0; i < auth.length(); ++i) {
            byte b = auth.byteAt(i);
            if (b != 34 && b != 92) continue;
            ++escapeCharCount;
        }
        if (escapeCharCount > 0) {
            if (escapeCharCount % 2 == 1) {
                throw new IllegalArgumentException("Illegal escape sequence in auth : " + auth);
            }
            byte[] unescapedCopy = new byte[auth.length() - escapeCharCount / 2];
            int pos = 0;
            for (int i = 0; i < auth.length(); ++i) {
                byte b = auth.byteAt(i);
                if (b == 92 ? (b = auth.byteAt(++i)) != 34 && b != 92 : b == 34) {
                    throw new IllegalArgumentException("Illegal escape sequence in auth : " + auth);
                }
                unescapedCopy[pos++] = b;
            }
            return new ArrayByteSequence(unescapedCopy);
        }
        return auth;
    }

    static Authorizations escape(Authorizations auths) {
        ArrayList<byte[]> retAuths = new ArrayList<byte[]>(auths.getAuthorizations().size());
        for (byte[] auth : auths.getAuthorizations()) {
            retAuths.add(VisibilityEvaluator.escape(auth, false));
        }
        return new Authorizations((Collection<byte[]>)retAuths);
    }

    public static byte[] escape(byte[] auth, boolean quote) {
        int escapeCount = 0;
        for (byte value : auth) {
            if (value != 34 && value != 92) continue;
            ++escapeCount;
        }
        if (escapeCount > 0 || quote) {
            byte[] escapedAuth = new byte[auth.length + escapeCount + (quote ? 2 : 0)];
            int index = quote ? 1 : 0;
            for (byte b : auth) {
                if (b == 34 || b == 92) {
                    escapedAuth[index++] = 92;
                }
                escapedAuth[index++] = b;
            }
            if (quote) {
                escapedAuth[0] = 34;
                escapedAuth[escapedAuth.length - 1] = 34;
            }
            auth = escapedAuth;
        }
        return auth;
    }

    public VisibilityEvaluator(AuthorizationContainer authsContainer) {
        this.auths = new UnescapingAuthorizationContainer(authsContainer);
    }

    public VisibilityEvaluator(Authorizations authorizations) {
        this.auths = VisibilityEvaluator.escape(authorizations);
    }

    public boolean evaluate(ColumnVisibility visibility) throws VisibilityParseException {
        return this.evaluate(visibility.getExpression(), visibility.getParseTree());
    }

    private final boolean evaluate(byte[] expression, ColumnVisibility.Node root) throws VisibilityParseException {
        if (expression.length == 0) {
            return true;
        }
        switch (root.type) {
            case TERM: {
                return this.auths.contains(root.getTerm(expression));
            }
            case AND: {
                if (root.children == null || root.children.size() < 2) {
                    throw new VisibilityParseException("AND has less than 2 children", expression, root.start);
                }
                for (ColumnVisibility.Node child : root.children) {
                    if (this.evaluate(expression, child)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                if (root.children == null || root.children.size() < 2) {
                    throw new VisibilityParseException("OR has less than 2 children", expression, root.start);
                }
                for (ColumnVisibility.Node child : root.children) {
                    if (!this.evaluate(expression, child)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new VisibilityParseException("No such node type", expression, root.start);
    }

    private static class UnescapingAuthorizationContainer
    implements AuthorizationContainer {
        private AuthorizationContainer wrapped;

        UnescapingAuthorizationContainer(AuthorizationContainer wrapee) {
            this.wrapped = wrapee;
        }

        @Override
        public boolean contains(ByteSequence auth) {
            return this.wrapped.contains(VisibilityEvaluator.unescape(auth));
        }
    }
}

