/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.compaction.CompactionExecutorIdImpl;
import org.apache.hadoop.fs.Path;

public class ExternalCompactionMetadata {
    private final Set<StoredTabletFile> jobFiles;
    private final Set<StoredTabletFile> nextFiles;
    private final ReferencedTabletFile compactTmpName;
    private final String compactorId;
    private final CompactionKind kind;
    private final short priority;
    private final CompactionExecutorId ceid;
    private final boolean propagateDeletes;
    private final boolean initiallySelectedAll;
    private final Long compactionId;

    public ExternalCompactionMetadata(Set<StoredTabletFile> jobFiles, Set<StoredTabletFile> nextFiles, ReferencedTabletFile compactTmpName, String compactorId, CompactionKind kind, short priority, CompactionExecutorId ceid, boolean propagateDeletes, boolean initiallySelectedAll, Long compactionId) {
        if (!(initiallySelectedAll || propagateDeletes || kind != CompactionKind.SELECTOR && kind != CompactionKind.USER)) {
            throw new IllegalArgumentException("When user or selector compactions do not propagate deletes, it's expected that all files were selected initially.");
        }
        this.jobFiles = Objects.requireNonNull(jobFiles);
        this.nextFiles = Objects.requireNonNull(nextFiles);
        this.compactTmpName = Objects.requireNonNull(compactTmpName);
        this.compactorId = Objects.requireNonNull(compactorId);
        this.kind = Objects.requireNonNull(kind);
        this.priority = priority;
        this.ceid = Objects.requireNonNull(ceid);
        this.propagateDeletes = propagateDeletes;
        this.initiallySelectedAll = initiallySelectedAll;
        this.compactionId = compactionId;
    }

    public Set<StoredTabletFile> getJobFiles() {
        return this.jobFiles;
    }

    public Set<StoredTabletFile> getNextFiles() {
        return this.nextFiles;
    }

    public ReferencedTabletFile getCompactTmpName() {
        return this.compactTmpName;
    }

    public String getCompactorId() {
        return this.compactorId;
    }

    public CompactionKind getKind() {
        return this.kind;
    }

    public short getPriority() {
        return this.priority;
    }

    public CompactionExecutorId getCompactionExecutorId() {
        return this.ceid;
    }

    public boolean getPropagateDeletes() {
        return this.propagateDeletes;
    }

    public boolean getInitiallySelecteAll() {
        return this.initiallySelectedAll;
    }

    public Long getCompactionId() {
        return this.compactionId;
    }

    public String toJson() {
        GSonData jData = new GSonData();
        jData.inputs = this.jobFiles.stream().map(StoredTabletFile::getMetaUpdateDelete).collect(Collectors.toList());
        jData.nextFiles = this.nextFiles.stream().map(StoredTabletFile::getMetaUpdateDelete).collect(Collectors.toList());
        jData.tmp = this.compactTmpName.getMetaInsert();
        jData.compactor = this.compactorId;
        jData.kind = this.kind.name();
        jData.executorId = ((CompactionExecutorIdImpl)this.ceid).getExternalName();
        jData.priority = this.priority;
        jData.propDels = this.propagateDeletes;
        jData.selectedAll = this.initiallySelectedAll;
        jData.compactionId = this.compactionId;
        return LazySingletons.GSON.get().toJson((Object)jData);
    }

    public static ExternalCompactionMetadata fromJson(String json) {
        GSonData jData = (GSonData)LazySingletons.GSON.get().fromJson(json, GSonData.class);
        return new ExternalCompactionMetadata(jData.inputs.stream().map(StoredTabletFile::new).collect(Collectors.toSet()), jData.nextFiles.stream().map(StoredTabletFile::new).collect(Collectors.toSet()), new ReferencedTabletFile(new Path(jData.tmp)), jData.compactor, CompactionKind.valueOf(jData.kind), jData.priority, CompactionExecutorIdImpl.externalId(jData.executorId), jData.propDels, jData.selectedAll, jData.compactionId);
    }

    public String toString() {
        return this.toJson();
    }

    private static class GSonData {
        List<String> inputs;
        List<String> nextFiles;
        String tmp;
        String compactor;
        String kind;
        String executorId;
        short priority;
        boolean propDels;
        boolean selectedAll;
        Long compactionId;

        private GSonData() {
        }
    }
}

