/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.metadata.AbstractTabletFile;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class UnreferencedTabletFile
extends AbstractTabletFile<UnreferencedTabletFile> {
    private final String fileName;

    public UnreferencedTabletFile(FileSystem fs, Path path) {
        super(Objects.requireNonNull(fs).makeQualified(Objects.requireNonNull(path)));
        this.fileName = path.getName();
        ValidationUtil.validateFileName(this.fileName);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int compareTo(UnreferencedTabletFile o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.path.compareTo(o.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnreferencedTabletFile) {
            UnreferencedTabletFile that = (UnreferencedTabletFile)obj;
            return this.path.equals((Object)that.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.toString();
    }

    public static UnreferencedTabletFile of(FileSystem fs, File file) {
        return new UnreferencedTabletFile(fs, new Path(Objects.requireNonNull(file).toString()));
    }

    public static UnreferencedTabletFile of(FileSystem fs, Path path) {
        return new UnreferencedTabletFile(fs, path);
    }

    public static UnreferencedTabletFile of(Configuration conf, Path path) throws IOException {
        return new UnreferencedTabletFile(Objects.requireNonNull(path).getFileSystem(conf), path);
    }
}

