/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.net.URI;
import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.AbstractTabletFile;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class StoredTabletFile
extends AbstractTabletFile<StoredTabletFile> {
    private final String metadataEntry;
    private final ReferencedTabletFile referencedTabletFile;

    public StoredTabletFile(String metadataEntry) {
        super(new Path(URI.create(metadataEntry)));
        this.metadataEntry = metadataEntry;
        this.referencedTabletFile = ReferencedTabletFile.of(this.getPath());
    }

    public String getMetaUpdateDelete() {
        return this.metadataEntry;
    }

    public Text getMetaUpdateDeleteText() {
        return new Text(this.getMetaUpdateDelete());
    }

    public ReferencedTabletFile getTabletFile() {
        return this.referencedTabletFile;
    }

    public TableId getTableId() {
        return this.referencedTabletFile.getTableId();
    }

    @Override
    public String getFileName() {
        return this.referencedTabletFile.getFileName();
    }

    public String getNormalizedPathStr() {
        return this.referencedTabletFile.getNormalizedPathStr();
    }

    @Override
    public int compareTo(StoredTabletFile o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.metadataEntry.compareTo(o.metadataEntry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredTabletFile that = (StoredTabletFile)o;
        return Objects.equals(this.metadataEntry, that.metadataEntry);
    }

    public int hashCode() {
        return Objects.hash(this.metadataEntry);
    }

    public String toString() {
        return this.metadataEntry;
    }

    public static void validate(String metadataEntry) {
        ReferencedTabletFile.parsePath(new Path(URI.create(metadataEntry)));
    }

    public static StoredTabletFile of(String metadataEntry) {
        return new StoredTabletFile(metadataEntry);
    }
}

