/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.net.URI;
import java.util.Objects;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;

public class CompactableFileImpl
implements CompactableFile {
    private final StoredTabletFile storedTabletFile;
    private final DataFileValue dataFileValue;

    public CompactableFileImpl(URI uri, long size, long entries) {
        this.storedTabletFile = new StoredTabletFile(uri.toString());
        this.dataFileValue = new DataFileValue(size, entries);
    }

    public CompactableFileImpl(StoredTabletFile storedTabletFile, DataFileValue dataFileValue) {
        this.storedTabletFile = Objects.requireNonNull(storedTabletFile);
        this.dataFileValue = Objects.requireNonNull(dataFileValue);
    }

    @Override
    public URI getUri() {
        return this.storedTabletFile.getPath().toUri();
    }

    @Override
    public String getFileName() {
        return this.storedTabletFile.getFileName();
    }

    @Override
    public long getEstimatedSize() {
        return this.dataFileValue.getSize();
    }

    @Override
    public long getEstimatedEntries() {
        return this.dataFileValue.getNumEntries();
    }

    public StoredTabletFile getStoredTabletFile() {
        return this.storedTabletFile;
    }

    public boolean equals(Object o) {
        if (o instanceof CompactableFileImpl) {
            CompactableFileImpl ocfi = (CompactableFileImpl)o;
            return this.storedTabletFile.equals(ocfi.storedTabletFile);
        }
        return false;
    }

    public int hashCode() {
        return this.storedTabletFile.hashCode();
    }

    public static StoredTabletFile toStoredTabletFile(CompactableFile cf) {
        if (cf instanceof CompactableFileImpl) {
            return ((CompactableFileImpl)cf).storedTabletFile;
        }
        throw new IllegalArgumentException("Can not convert " + cf.getClass());
    }

    public String toString() {
        return "[" + this.storedTabletFile.getFileName() + ", " + this.dataFileValue + "]";
    }
}

