/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.manager.balancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;

public class BalanceParamsImpl
implements TabletBalancer.BalanceParameters {
    private final SortedMap<TabletServerId, TServerStatus> currentStatus;
    private final Set<TabletId> currentMigrations;
    private final List<TabletMigration> migrationsOut;
    private final SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus;
    private final Set<KeyExtent> thriftCurrentMigrations;

    public static BalanceParamsImpl fromThrift(SortedMap<TabletServerId, TServerStatus> currentStatus, SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus, Set<KeyExtent> thriftCurrentMigrations) {
        Set<TabletId> currentMigrations = thriftCurrentMigrations.stream().map(TabletIdImpl::new).collect(Collectors.toUnmodifiableSet());
        return new BalanceParamsImpl(currentStatus, currentMigrations, new ArrayList<TabletMigration>(), thriftCurrentStatus, thriftCurrentMigrations);
    }

    public BalanceParamsImpl(SortedMap<TabletServerId, TServerStatus> currentStatus, Set<TabletId> currentMigrations, List<TabletMigration> migrationsOut) {
        this.currentStatus = currentStatus;
        this.currentMigrations = currentMigrations;
        this.migrationsOut = migrationsOut;
        this.thriftCurrentStatus = null;
        this.thriftCurrentMigrations = null;
    }

    private BalanceParamsImpl(SortedMap<TabletServerId, TServerStatus> currentStatus, Set<TabletId> currentMigrations, List<TabletMigration> migrationsOut, SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus, Set<KeyExtent> thriftCurrentMigrations) {
        this.currentStatus = currentStatus;
        this.currentMigrations = currentMigrations;
        this.migrationsOut = migrationsOut;
        this.thriftCurrentStatus = thriftCurrentStatus;
        this.thriftCurrentMigrations = thriftCurrentMigrations;
    }

    @Override
    public SortedMap<TabletServerId, TServerStatus> currentStatus() {
        return this.currentStatus;
    }

    @Override
    public Set<TabletId> currentMigrations() {
        return this.currentMigrations;
    }

    @Override
    public List<TabletMigration> migrationsOut() {
        return this.migrationsOut;
    }

    public SortedMap<TServerInstance, TabletServerStatus> thriftCurrentStatus() {
        return this.thriftCurrentStatus;
    }

    public Set<KeyExtent> thriftCurrentMigrations() {
        return this.thriftCurrentMigrations;
    }

    public void addMigration(KeyExtent extent, TServerInstance oldServer, TServerInstance newServer) {
        TabletIdImpl id = new TabletIdImpl(extent);
        TabletServerIdImpl oldTsid = new TabletServerIdImpl(oldServer);
        TabletServerIdImpl newTsid = new TabletServerIdImpl(newServer);
        this.migrationsOut.add(new TabletMigration(id, oldTsid, newTsid));
    }
}

