/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.VisibilityEvaluator;
import org.apache.accumulo.core.security.VisibilityParseException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransformingIterator
extends WrappingIterator
implements OptionDescriber {
    public static final String AUTH_OPT = "authorizations";
    public static final String MAX_BUFFER_SIZE_OPT = "maxBufferSize";
    private static final long DEFAULT_MAX_BUFFER_SIZE = 10000000L;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected ArrayList<Pair<Key, Value>> keys = new ArrayList();
    protected int keyPos = -1;
    protected boolean scanning;
    protected Range seekRange;
    protected Collection<ByteSequence> seekColumnFamilies;
    protected boolean seekColumnFamiliesInclusive;
    private VisibilityEvaluator ve = null;
    private LRUMap<ByteSequence, Boolean> visibleCache = null;
    private LRUMap<ByteSequence, Boolean> parsedVisibilitiesCache = null;
    private long maxBufferSize;
    private static Comparator<Pair<Key, Value>> keyComparator = Comparator.comparing(Pair::getFirst);

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        String auths;
        super.init(source, options, env);
        this.scanning = IteratorUtil.IteratorScope.scan.equals((Object)env.getIteratorScope());
        if (this.scanning && (auths = options.get(AUTH_OPT)) != null && !auths.isEmpty()) {
            this.ve = new VisibilityEvaluator(new Authorizations(auths.getBytes(StandardCharsets.UTF_8)));
            this.visibleCache = new LRUMap(100);
        }
        this.maxBufferSize = options.containsKey(MAX_BUFFER_SIZE_OPT) ? ConfigurationTypeHelper.getFixedMemoryAsBytes(options.get(MAX_BUFFER_SIZE_OPT)) : 10000000L;
        this.parsedVisibilitiesCache = new LRUMap(100);
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        String desc = "This iterator allows ranges of key to be transformed (with the exception of row transformations).";
        String authDesc = "Comma-separated list of user's scan authorizations.  If excluded or empty, then no visibility check is performed on transformed keys.";
        String bufferDesc = "Maximum buffer size (in accumulo memory spec) to use for buffering keys before throwing a BufferOverflowException. Users should keep this limit in mind when deciding what to transform. That is, if transforming the column family for example, then all keys sharing the same row and column family must fit within this limit (along with their associated values)";
        HashMap<String, String> namedOptions = new HashMap<String, String>();
        namedOptions.put(AUTH_OPT, authDesc);
        namedOptions.put(MAX_BUFFER_SIZE_OPT, bufferDesc);
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), desc, namedOptions, null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        for (Map.Entry<String, String> option : options.entrySet()) {
            try {
                if (option.getKey().equals(AUTH_OPT)) {
                    new Authorizations(option.getValue().getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                if (!option.getKey().equals(MAX_BUFFER_SIZE_OPT)) continue;
                ConfigurationTypeHelper.getFixedMemoryAsBytes(option.getValue());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse opt " + option.getKey() + " " + option.getValue(), e);
            }
        }
        return true;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        TransformingIterator copy;
        try {
            copy = (TransformingIterator)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
        copy.setSource(this.getSource().deepCopy(env));
        copy.scanning = this.scanning;
        copy.keyPos = this.keyPos;
        copy.keys.addAll(this.keys);
        copy.seekRange = this.seekRange == null ? null : new Range(this.seekRange);
        copy.seekColumnFamilies = this.seekColumnFamilies == null ? null : new HashSet<ByteSequence>(this.seekColumnFamilies);
        copy.seekColumnFamiliesInclusive = this.seekColumnFamiliesInclusive;
        copy.ve = this.ve;
        if (this.visibleCache != null) {
            copy.visibleCache = new LRUMap(this.visibleCache.maxSize());
            copy.visibleCache.putAll(this.visibleCache);
        }
        if (this.parsedVisibilitiesCache != null) {
            copy.parsedVisibilitiesCache = new LRUMap(this.parsedVisibilitiesCache.maxSize());
            copy.parsedVisibilitiesCache.putAll(this.parsedVisibilitiesCache);
        }
        copy.maxBufferSize = this.maxBufferSize;
        return copy;
    }

    @Override
    public boolean hasTop() {
        return this.keyPos >= 0 && this.keyPos < this.keys.size();
    }

    @Override
    public Key getTopKey() {
        return this.hasTop() ? this.keys.get(this.keyPos).getFirst() : null;
    }

    @Override
    public Value getTopValue() {
        return this.hasTop() ? this.keys.get(this.keyPos).getSecond() : null;
    }

    @Override
    public void next() throws IOException {
        if (this.keyPos >= 0) {
            ++this.keyPos;
        }
        while (!this.hasTop() && super.hasTop()) {
            this.transformKeys();
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.seekRange = new Range(range);
        this.seekColumnFamilies = columnFamilies;
        this.seekColumnFamiliesInclusive = inclusive;
        super.seek(this.computeReseekRange(range), this.untransformColumnFamilies(columnFamilies), inclusive);
        this.keyPos = -1;
        while (!this.hasTop() && super.hasTop()) {
            this.transformKeys();
        }
    }

    protected void transformKeys() throws IOException {
        this.keyPos = -1;
        this.keys.clear();
        final Key prefixKey = super.hasTop() ? new Key(super.getTopKey()) : null;
        this.transformRange(new RangeIterator(this.getSource(), prefixKey, this.getKeyPrefix()), new KVBuffer(){
            long appened = 0L;

            @Override
            public void append(Key key, Value val) {
                if (!key.equals(prefixKey, TransformingIterator.this.getKeyPrefix())) {
                    throw new IllegalArgumentException("Key prefixes are not equal " + key + " " + prefixKey);
                }
                if (TransformingIterator.this.includeTransformedKey(key)) {
                    if (this.appened > TransformingIterator.this.maxBufferSize) {
                        throw new IllegalArgumentException("Exceeded buffer size of " + TransformingIterator.this.maxBufferSize + ", prefixKey: " + prefixKey);
                    }
                    if (TransformingIterator.this.getSource().hasTop() && key == TransformingIterator.this.getSource().getTopKey()) {
                        key = new Key(key);
                    }
                    TransformingIterator.this.keys.add(new Pair<Key, Value>(key, new Value(val)));
                    this.appened += (long)(key.getSize() + val.getSize() + 128);
                }
            }
        });
        while (super.hasTop() && super.getTopKey().equals(prefixKey, this.getKeyPrefix())) {
            super.next();
        }
        if (!this.keys.isEmpty()) {
            this.keys.sort(keyComparator);
            this.keyPos = 0;
        }
    }

    protected boolean includeTransformedKey(Key transformedKey) {
        boolean include = this.canSee(transformedKey);
        if (this.scanning && this.seekRange != null) {
            include = include && this.seekRange.contains(transformedKey);
        }
        return include;
    }

    protected boolean canSee(Key key) {
        ByteSequence visibility = key.getColumnVisibilityData();
        ColumnVisibility colVis = null;
        Boolean parsed = (Boolean)this.parsedVisibilitiesCache.get((Object)visibility);
        if (parsed == null) {
            try {
                colVis = new ColumnVisibility(visibility.toArray());
                this.parsedVisibilitiesCache.put((Object)visibility, (Object)Boolean.TRUE);
            }
            catch (BadArgumentException e) {
                this.log.error("Parse error after transformation : {}", (Object)visibility);
                this.parsedVisibilitiesCache.put((Object)visibility, (Object)Boolean.FALSE);
                if (this.scanning) {
                    return false;
                }
                throw e;
            }
        } else if (!parsed.booleanValue()) {
            if (this.scanning) {
                return false;
            }
            throw new IllegalStateException();
        }
        Boolean visible = this.canSeeColumnFamily(key);
        if (!this.scanning || !visible.booleanValue() || this.ve == null || this.visibleCache == null || visibility.length() == 0) {
            return visible;
        }
        visible = (Boolean)this.visibleCache.get((Object)visibility);
        if (visible == null) {
            try {
                if (colVis == null) {
                    colVis = new ColumnVisibility(visibility.toArray());
                }
                visible = this.ve.evaluate(colVis);
                this.visibleCache.put((Object)visibility, (Object)visible);
            }
            catch (VisibilityParseException | BadArgumentException e) {
                this.log.error("Parse Error", (Throwable)e);
                visible = Boolean.FALSE;
            }
        }
        return visible;
    }

    protected boolean canSeeColumnFamily(Key key) {
        boolean visible = true;
        if (this.seekColumnFamilies != null) {
            ByteSequence columnFamily = key.getColumnFamilyData();
            visible = this.seekColumnFamiliesInclusive ? this.seekColumnFamilies.contains(columnFamily) : !this.seekColumnFamilies.contains(columnFamily);
        }
        return visible;
    }

    protected Range computeReseekRange(Range range) {
        Key startKey = range.getStartKey();
        boolean startKeyInclusive = range.isStartKeyInclusive();
        if (this.isSetAfterPart(startKey, this.getKeyPrefix())) {
            startKey = this.copyPartialKey(startKey, this.getKeyPrefix());
            startKeyInclusive = true;
        }
        Key endKey = range.getEndKey();
        boolean endKeyInclusive = range.isEndKeyInclusive();
        if (this.isSetAfterPart(endKey, this.getKeyPrefix())) {
            endKey = endKey.followingKey(this.getKeyPrefix());
            endKeyInclusive = true;
        }
        return new Range(startKey, startKeyInclusive, endKey, endKeyInclusive);
    }

    protected boolean isSetAfterPart(Key key, PartialKey part) {
        if (key != null) {
            switch (part) {
                case ROW: {
                    return key.getColumnFamilyData().length() > 0 || key.getColumnQualifierData().length() > 0 || key.getColumnVisibilityData().length() > 0 || key.getTimestamp() < Long.MAX_VALUE || key.isDeleted();
                }
                case ROW_COLFAM: {
                    return key.getColumnQualifierData().length() > 0 || key.getColumnVisibilityData().length() > 0 || key.getTimestamp() < Long.MAX_VALUE || key.isDeleted();
                }
                case ROW_COLFAM_COLQUAL: {
                    return key.getColumnVisibilityData().length() > 0 || key.getTimestamp() < Long.MAX_VALUE || key.isDeleted();
                }
                case ROW_COLFAM_COLQUAL_COLVIS: {
                    return key.getTimestamp() < Long.MAX_VALUE || key.isDeleted();
                }
                case ROW_COLFAM_COLQUAL_COLVIS_TIME: {
                    return key.isDeleted();
                }
                case ROW_COLFAM_COLQUAL_COLVIS_TIME_DEL: {
                    return false;
                }
            }
        }
        return false;
    }

    protected Key copyPartialKey(Key key, PartialKey part) {
        Key keyCopy;
        switch (part) {
            case ROW: {
                keyCopy = new Key(key.getRow());
                break;
            }
            case ROW_COLFAM: {
                keyCopy = new Key(key.getRow(), key.getColumnFamily());
                break;
            }
            case ROW_COLFAM_COLQUAL: {
                keyCopy = new Key(key.getRow(), key.getColumnFamily(), key.getColumnQualifier());
                break;
            }
            case ROW_COLFAM_COLQUAL_COLVIS: {
                keyCopy = new Key(key.getRow(), key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibility());
                break;
            }
            case ROW_COLFAM_COLQUAL_COLVIS_TIME: {
                keyCopy = new Key(key.getRow(), key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibility(), key.getTimestamp());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported key part: " + part);
            }
        }
        return keyCopy;
    }

    protected Key replaceColumnFamily(Key originalKey, Text newColFam) {
        byte[] row = originalKey.getRowData().toArray();
        byte[] cf = newColFam.getBytes();
        byte[] cq = originalKey.getColumnQualifierData().toArray();
        byte[] cv = originalKey.getColumnVisibilityData().toArray();
        long timestamp = originalKey.getTimestamp();
        Key newKey = new Key(row, 0, row.length, cf, 0, newColFam.getLength(), cq, 0, cq.length, cv, 0, cv.length, timestamp);
        newKey.setDeleted(originalKey.isDeleted());
        return newKey;
    }

    protected Key replaceColumnQualifier(Key originalKey, Text newColQual) {
        byte[] row = originalKey.getRowData().toArray();
        byte[] cf = originalKey.getColumnFamilyData().toArray();
        byte[] cq = newColQual.getBytes();
        byte[] cv = originalKey.getColumnVisibilityData().toArray();
        long timestamp = originalKey.getTimestamp();
        Key newKey = new Key(row, 0, row.length, cf, 0, cf.length, cq, 0, newColQual.getLength(), cv, 0, cv.length, timestamp);
        newKey.setDeleted(originalKey.isDeleted());
        return newKey;
    }

    protected Key replaceColumnVisibility(Key originalKey, Text newColVis) {
        byte[] row = originalKey.getRowData().toArray();
        byte[] cf = originalKey.getColumnFamilyData().toArray();
        byte[] cq = originalKey.getColumnQualifierData().toArray();
        byte[] cv = newColVis.getBytes();
        long timestamp = originalKey.getTimestamp();
        Key newKey = new Key(row, 0, row.length, cf, 0, cf.length, cq, 0, cq.length, cv, 0, newColVis.getLength(), timestamp);
        newKey.setDeleted(originalKey.isDeleted());
        return newKey;
    }

    protected Key replaceKeyParts(Key originalKey, Text newColFam, Text newColQual, Text newColVis) {
        byte[] row = originalKey.getRowData().toArray();
        byte[] cf = newColFam.getBytes();
        byte[] cq = newColQual.getBytes();
        byte[] cv = newColVis.getBytes();
        long timestamp = originalKey.getTimestamp();
        Key newKey = new Key(row, 0, row.length, cf, 0, newColFam.getLength(), cq, 0, newColQual.getLength(), cv, 0, newColVis.getLength(), timestamp);
        newKey.setDeleted(originalKey.isDeleted());
        return newKey;
    }

    protected Key replaceKeyParts(Key originalKey, Text newColQual, Text newColVis) {
        byte[] row = originalKey.getRowData().toArray();
        byte[] cf = originalKey.getColumnFamilyData().toArray();
        byte[] cq = newColQual.getBytes();
        byte[] cv = newColVis.getBytes();
        long timestamp = originalKey.getTimestamp();
        Key newKey = new Key(row, 0, row.length, cf, 0, cf.length, cq, 0, newColQual.getLength(), cv, 0, newColVis.getLength(), timestamp);
        newKey.setDeleted(originalKey.isDeleted());
        return newKey;
    }

    protected Collection<ByteSequence> untransformColumnFamilies(Collection<ByteSequence> columnFamilies) {
        return columnFamilies;
    }

    protected abstract PartialKey getKeyPrefix();

    protected abstract void transformRange(SortedKeyValueIterator<Key, Value> var1, KVBuffer var2) throws IOException;

    public static void setAuthorizations(IteratorSetting config, Authorizations auths) {
        config.addOption(AUTH_OPT, auths.serialize());
    }

    public static void setMaxBufferSize(IteratorSetting config, long maxBufferSize) {
        config.addOption(MAX_BUFFER_SIZE_OPT, "" + maxBufferSize);
    }

    public static interface KVBuffer {
        public void append(Key var1, Value var2);
    }

    private static class RangeIterator
    implements SortedKeyValueIterator<Key, Value> {
        private SortedKeyValueIterator<Key, Value> source;
        private Key prefixKey;
        private PartialKey keyPrefix;
        private boolean hasTop = false;

        RangeIterator(SortedKeyValueIterator<Key, Value> source, Key prefixKey, PartialKey keyPrefix) {
            this.source = source;
            this.prefixKey = prefixKey;
            this.keyPrefix = keyPrefix;
        }

        @Override
        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasTop() {
            this.hasTop = this.source.hasTop() && this.source.getTopKey().equals(this.prefixKey, this.keyPrefix);
            return this.hasTop;
        }

        @Override
        public void next() throws IOException {
            if (!this.hasTop && !this.hasTop()) {
                throw new NoSuchElementException();
            }
            this.hasTop = false;
            this.source.next();
        }

        @Override
        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Key getTopKey() {
            return this.source.getTopKey();
        }

        @Override
        public Value getTopValue() {
            return this.source.getTopValue();
        }

        @Override
        public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
            throw new UnsupportedOperationException();
        }
    }
}

