/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto;

import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.CryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.GenericCryptoServiceFactory;
import org.apache.accumulo.core.spi.crypto.NoCryptoServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoFactoryLoader {
    private static final Logger log = LoggerFactory.getLogger(CryptoFactoryLoader.class);
    private static final CryptoServiceFactory NO_CRYPTO_FACTORY = new NoCryptoServiceFactory();

    public static CryptoServiceFactory newInstance(AccumuloConfiguration conf) {
        String clazzName = conf.get(Property.INSTANCE_CRYPTO_FACTORY);
        return CryptoFactoryLoader.loadCryptoFactory(ClassloaderType.ACCUMULO, clazzName);
    }

    public static CryptoService getServiceForServer(AccumuloConfiguration conf) {
        CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, null, null);
        CryptoServiceFactory factory = CryptoFactoryLoader.newInstance(conf);
        Map<String, String> allCryptoProperties = conf.getAllCryptoProperties();
        return factory.getService(env, allCryptoProperties);
    }

    public static CryptoService getServiceForClient(CryptoEnvironment.Scope scope, Map<String, String> properties) {
        CryptoServiceFactory factory = CryptoFactoryLoader.loadCryptoFactory(ClassloaderType.JAVA, GenericCryptoServiceFactory.class.getName());
        CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(scope, null, null);
        return factory.getService(env, properties);
    }

    public static CryptoService getServiceForClientWithTable(Map<String, String> systemConfig, Map<String, String> tableProps, TableId tableId) {
        String factoryKey = Property.INSTANCE_CRYPTO_FACTORY.getKey();
        String clazzName = systemConfig.get(factoryKey);
        if (clazzName == null || clazzName.trim().isEmpty()) {
            return NoCryptoServiceFactory.NONE;
        }
        CryptoEnvironmentImpl env = new CryptoEnvironmentImpl(CryptoEnvironment.Scope.TABLE, tableId, null);
        CryptoServiceFactory factory = CryptoFactoryLoader.loadCryptoFactory(ClassloaderType.JAVA, clazzName);
        return factory.getService(env, tableProps);
    }

    private static CryptoServiceFactory loadCryptoFactory(ClassloaderType ct, String clazzName) {
        CryptoServiceFactory newCryptoServiceFactory;
        log.debug("Creating new crypto factory class {}", (Object)clazzName);
        if (ct == ClassloaderType.ACCUMULO) {
            newCryptoServiceFactory = ConfigurationTypeHelper.getClassInstance(null, clazzName, CryptoServiceFactory.class, new NoCryptoServiceFactory());
        } else if (ct == ClassloaderType.JAVA) {
            if (clazzName == null || clazzName.trim().isEmpty()) {
                newCryptoServiceFactory = NO_CRYPTO_FACTORY;
            } else {
                try {
                    newCryptoServiceFactory = CryptoFactoryLoader.class.getClassLoader().loadClass(clazzName).asSubclass(CryptoServiceFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        return newCryptoServiceFactory;
    }

    static enum ClassloaderType {
        ACCUMULO,
        JAVA;

    }
}

