/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletLocatorImpl;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootTabletLocator
extends TabletLocator {
    private final TabletLocatorImpl.TabletServerLockChecker lockChecker;

    RootTabletLocator(TabletLocatorImpl.TabletServerLockChecker lockChecker) {
        this.lockChecker = lockChecker;
    }

    @Override
    public <T extends Mutation> void binMutations(ClientContext context, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) {
        TabletLocator.TabletLocation rootTabletLocation = this.getRootTabletLocation(context);
        if (rootTabletLocation != null) {
            TabletLocator.TabletServerMutations<Mutation> tsm = new TabletLocator.TabletServerMutations<Mutation>(rootTabletLocation.getTserverSession());
            for (Mutation mutation : mutations) {
                tsm.addMutation(RootTable.EXTENT, mutation);
            }
            binnedMutations.put(rootTabletLocation.getTserverLocation(), tsm);
        } else {
            failures.addAll(mutations);
        }
    }

    @Override
    public List<Range> binRanges(ClientContext context, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) {
        TabletLocator.TabletLocation rootTabletLocation = this.getRootTabletLocation(context);
        if (rootTabletLocation != null) {
            for (Range range : ranges) {
                TabletLocatorImpl.addRange(binnedRanges, rootTabletLocation.getTserverLocation(), RootTable.EXTENT, range);
            }
            return Collections.emptyList();
        }
        return ranges;
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
    }

    @Override
    public void invalidateCache(ClientContext context, String server) {
        ZooCache zooCache = context.getZooCache();
        String root = context.getZooKeeperRoot() + "/tservers";
        zooCache.clear(root + "/" + server);
    }

    @Override
    public void invalidateCache() {
    }

    protected TabletLocator.TabletLocation getRootTabletLocation(ClientContext context) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        TabletMetadata.Location loc = context.getAmple().readTablet(RootTable.EXTENT, Ample.ReadConsistency.EVENTUAL, TabletMetadata.ColumnType.LOCATION).getLocation();
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null || loc.getType() != TabletMetadata.LocationType.CURRENT) {
            return null;
        }
        String server = loc.getHostPort();
        if (this.lockChecker.isLockHeld(server, loc.getSession())) {
            return new TabletLocator.TabletLocation(RootTable.EXTENT, server, loc.getSession());
        }
        return null;
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(ClientContext context, Text row, boolean skipRow, boolean retry) {
        TabletLocator.TabletLocation location = this.getRootTabletLocation(context);
        while (retry && location == null) {
            Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            location = this.getRootTabletLocation(context);
        }
        return location;
    }
}

