/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;

public class BatchWriterImpl
implements BatchWriter {
    private final TableId tableId;
    private final TabletServerBatchWriter bw;

    public BatchWriterImpl(ClientContext context, TableId tableId, BatchWriterConfig config) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        if (config == null) {
            config = new BatchWriterConfig();
        }
        this.tableId = tableId;
        this.bw = new TabletServerBatchWriter(context, config);
    }

    @Override
    public void addMutation(Mutation m) throws MutationsRejectedException {
        Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
        this.bw.addMutation(this.tableId, m);
    }

    @Override
    public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
        Preconditions.checkArgument((iterable != null ? 1 : 0) != 0, (Object)"iterable is null");
        this.bw.addMutation(this.tableId, iterable.iterator());
    }

    @Override
    public void close() throws MutationsRejectedException {
        this.bw.close();
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }
}

