/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary.summarizers;

import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;

public class DeletesSummarizer
implements Summarizer {
    public static final String DELETES_STAT = "deletes";
    public static final String TOTAL_STAT = "total";

    @Override
    public Summarizer.Collector collector(SummarizerConfiguration sc) {
        return new Summarizer.Collector(){
            long total = 0L;
            long deletes = 0L;

            @Override
            public void accept(Key k, Value v) {
                ++this.total;
                if (k.isDeleted()) {
                    ++this.deletes;
                }
            }

            @Override
            public void summarize(Summarizer.StatisticConsumer sc) {
                sc.accept(DeletesSummarizer.DELETES_STAT, this.deletes);
                sc.accept(DeletesSummarizer.TOTAL_STAT, this.total);
            }
        };
    }

    @Override
    public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
        return (m1, m2) -> m2.forEach((k, v) -> m1.merge(k, v, Long::sum));
    }
}

