/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.collections4.map.LRUMap;

public class RFileWriter
implements AutoCloseable {
    private FileSKVWriter writer;
    private final LRUMap<ByteSequence, Boolean> validVisibilities;
    private boolean startedLG;
    private boolean startedDefaultLG;

    RFileWriter(FileSKVWriter fileSKVWriter, int visCacheSize) {
        this.writer = fileSKVWriter;
        this.validVisibilities = new LRUMap(visCacheSize);
    }

    private void _startNewLocalityGroup(String name, Set<ByteSequence> columnFamilies) throws IOException {
        Preconditions.checkState((!this.startedDefaultLG ? 1 : 0) != 0, (Object)"Cannot start a locality group after starting the default locality group");
        this.writer.startNewLocalityGroup(name, columnFamilies);
        this.startedLG = true;
    }

    public void startNewLocalityGroup(String name, List<byte[]> families) throws IOException {
        HashSet<ByteSequence> fams = new HashSet<ByteSequence>();
        for (byte[] family : families) {
            fams.add(new ArrayByteSequence(family));
        }
        this._startNewLocalityGroup(name, fams);
    }

    public void startNewLocalityGroup(String name, byte[] ... families) throws IOException {
        this.startNewLocalityGroup(name, Arrays.asList(families));
    }

    public void startNewLocalityGroup(String name, Set<String> families) throws IOException {
        HashSet<ByteSequence> fams = new HashSet<ByteSequence>();
        for (String family : families) {
            fams.add(new ArrayByteSequence(family));
        }
        this._startNewLocalityGroup(name, fams);
    }

    public void startNewLocalityGroup(String name, String ... families) throws IOException {
        HashSet<ByteSequence> fams = new HashSet<ByteSequence>();
        for (String family : families) {
            fams.add(new ArrayByteSequence(family));
        }
        this._startNewLocalityGroup(name, fams);
    }

    public void startDefaultLocalityGroup() throws IOException {
        Preconditions.checkState((!this.startedDefaultLG ? 1 : 0) != 0);
        this.writer.startDefaultLocalityGroup();
        this.startedDefaultLG = true;
        this.startedLG = true;
    }

    public void append(Key key, Value val) throws IOException {
        Boolean wasChecked;
        if (!this.startedLG) {
            this.startDefaultLocalityGroup();
        }
        if ((wasChecked = (Boolean)this.validVisibilities.get((Object)key.getColumnVisibilityData())) == null) {
            byte[] cv = key.getColumnVisibilityData().toArray();
            new ColumnVisibility(cv);
            this.validVisibilities.put((Object)new ArrayByteSequence(Arrays.copyOf(cv, cv.length)), (Object)Boolean.TRUE);
        }
        this.writer.append(key, val);
    }

    public void append(Key key, CharSequence value) throws IOException {
        this.append(key, new Value(value));
    }

    public void append(Key key, byte[] value) throws IOException {
        this.append(key, new Value(value));
    }

    public void append(Iterable<Map.Entry<Key, Value>> keyValues) throws IOException {
        for (Map.Entry<Key, Value> entry : keyValues) {
            this.append(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

