/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;

public class UIntegerLexicoder
extends AbstractLexicoder<Integer> {
    @Override
    public byte[] encode(Integer i) {
        int index;
        int shift = 56;
        int prefix = i < 0 ? 255 : 0;
        for (index = 0; index < 4 && (i >>> shift & 0xFF) == prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[5 - index];
        ret[0] = (byte)(4 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(i >>> shift);
            shift -= 8;
        }
        if (i < 0) {
            ret[0] = (byte)(8 - ret[0]);
        }
        return ret;
    }

    @Override
    public Integer decode(byte[] b) {
        return (Integer)super.decode(b);
    }

    @Override
    protected Integer decodeUnchecked(byte[] data, int offset, int len) {
        if (data[offset] < 0 || data[offset] > 8) {
            throw new IllegalArgumentException("Unexpected length " + (0xFF & data[offset]));
        }
        int i = 0;
        int shift = 0;
        for (int idx = offset + len - 1; idx >= offset + 1; --idx) {
            i += (data[idx] & 0xFF) << shift;
            shift += 8;
        }
        if (data[offset] > 4) {
            i |= -1 << (8 - data[offset] << 3);
        }
        return i;
    }
}

