/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.List;
import java.util.Optional;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.server.ServerContext;

public class TabletServerLocks {
    public static void execute(ServerContext context, String lock, String delete) throws Exception {
        String tserverPath = context.getZooKeeperRoot() + "/tservers";
        ZooCache cache = context.getZooCache();
        ZooReaderWriter zoo = context.getZooReaderWriter();
        if (delete == null) {
            List tabletServers = zoo.getChildren(tserverPath);
            if (tabletServers.isEmpty()) {
                System.err.println("No tservers found in ZK at " + tserverPath);
            }
            for (String tabletServer : tabletServers) {
                ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(tserverPath + "/" + tabletServer));
                Optional lockData = ServiceLock.getLockData((ZooCache)cache, (ServiceLock.ServiceLockPath)zLockPath, null);
                String holder = lockData.isPresent() ? ((ServiceLockData)lockData.orElseThrow()).getAddressString(ServiceLockData.ThriftService.TSERV) : "<none>";
                System.out.printf("%32s %16s%n", tabletServer, holder);
            }
        } else {
            if (lock == null) {
                TabletServerLocks.printUsage();
            }
            ServiceLock.ServiceLockPath path = ServiceLock.path((String)(tserverPath + "/" + lock));
            ServiceLock.deleteLock((ZooReaderWriter)zoo, (ServiceLock.ServiceLockPath)path);
            System.out.printf("Deleted %s", path);
        }
    }

    private static void printUsage() {
        System.out.println("Usage : accumulo admin locks -delete <tserver lock>");
    }
}

