/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListInstances {
    private static final Logger log = LoggerFactory.getLogger(ListInstances.class);
    private static final int NAME_WIDTH = 20;
    private static final int UUID_WIDTH = 37;
    private static final int MANAGER_WIDTH = 30;
    private static final int ZOOKEEPER_TIMER_MILLIS = 30000;
    static Opts opts = new Opts();
    static int errors = 0;

    public static void main(String[] args) {
        opts.parseArgs(ListInstances.class.getName(), args, new Object[0]);
        if (ListInstances.opts.keepers == null) {
            SiteConfiguration siteConfig = SiteConfiguration.auto();
            ListInstances.opts.keepers = siteConfig.get(Property.INSTANCE_ZK_HOST);
        }
        String keepers = ListInstances.opts.keepers;
        boolean printAll = ListInstances.opts.printAll;
        boolean printErrors = ListInstances.opts.printErrors;
        ListInstances.listInstances(keepers, printAll, printErrors);
    }

    static synchronized void listInstances(String keepers, boolean printAll, boolean printErrors) {
        errors = 0;
        System.out.println("INFO : Using ZooKeepers " + keepers);
        ZooReader rdr = new ZooReader(keepers, 30000);
        ZooCache cache = new ZooCache(rdr, null);
        TreeMap<String, InstanceId> instanceNames = ListInstances.getInstanceNames(rdr, printErrors);
        System.out.println();
        ListInstances.printHeader();
        for (Map.Entry<String, InstanceId> entry : instanceNames.entrySet()) {
            ListInstances.printInstanceInfo(cache, entry.getKey(), entry.getValue(), printErrors);
        }
        TreeSet<InstanceId> instancedIds = ListInstances.getInstanceIDs(rdr, printErrors);
        instancedIds.removeAll(instanceNames.values());
        if (printAll) {
            for (InstanceId uuid : instancedIds) {
                ListInstances.printInstanceInfo(cache, null, uuid, printErrors);
            }
        } else if (!instancedIds.isEmpty()) {
            System.out.println();
            System.out.println("INFO : " + instancedIds.size() + " unnamed instances were not printed, run with --print-all to see all instances");
        } else {
            System.out.println();
        }
        if (!printErrors && errors > 0) {
            System.err.println("WARN : There were " + errors + " errors, run with --print-errors to see more info");
        }
    }

    private static void printHeader() {
        System.out.printf(" %-20s| %-37s| %-30s%n", "Instance Name", "Instance ID", "Manager");
        System.out.printf("%21s+%38s+%31s%n", new CharFiller('-'), new CharFiller('-'), new CharFiller('-'));
    }

    private static void printInstanceInfo(ZooCache cache, String instanceName, InstanceId iid, boolean printErrors) {
        String manager = ListInstances.getManager(cache, iid, printErrors);
        if (instanceName == null) {
            instanceName = "";
        }
        if (manager == null) {
            manager = "";
        }
        System.out.printf("%20s |%37s |%30s%n", "\"" + instanceName + "\"", iid, manager);
    }

    private static String getManager(ZooCache cache, InstanceId iid, boolean printErrors) {
        if (iid == null) {
            return null;
        }
        try {
            ServiceLock.ServiceLockPath zLockManagerPath = ServiceLock.path((String)("/accumulo/" + iid + "/managers/lock"));
            Optional sld = ServiceLock.getLockData((ZooCache)cache, (ServiceLock.ServiceLockPath)zLockManagerPath, null);
            if (sld.isEmpty()) {
                return null;
            }
            return ((ServiceLockData)sld.orElseThrow()).getAddressString(ServiceLockData.ThriftService.MANAGER);
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
            return null;
        }
    }

    private static TreeMap<String, InstanceId> getInstanceNames(ZooReader zk, boolean printErrors) {
        List names;
        String instancesPath = "/accumulo/instances";
        TreeMap<String, InstanceId> tm = new TreeMap<String, InstanceId>();
        try {
            names = zk.getChildren(instancesPath);
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
            return tm;
        }
        for (String name : names) {
            String instanceNamePath = "/accumulo/instances/" + name;
            try {
                InstanceId iid = InstanceId.of((String)new String(zk.getData(instanceNamePath), StandardCharsets.UTF_8));
                tm.put(name, iid);
            }
            catch (Exception e) {
                ListInstances.handleException(e, printErrors);
                tm.put(name, null);
            }
        }
        return tm;
    }

    private static TreeSet<InstanceId> getInstanceIDs(ZooReader zk, boolean printErrors) {
        TreeSet<InstanceId> ts = new TreeSet<InstanceId>();
        try {
            List children = zk.getChildren("/accumulo");
            for (String iid : children) {
                if (iid.equals("instances")) continue;
                try {
                    ts.add(InstanceId.of((String)iid));
                }
                catch (Exception e) {
                    log.error("Exception: ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
        }
        return ts;
    }

    private static void handleException(Exception e, boolean printErrors) {
        if (printErrors) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        ++errors;
    }

    private static class CharFiller
    implements Formattable {
        char c;

        CharFiller(char c) {
            this.c = c;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            formatter.format(String.valueOf(this.c).repeat(Math.max(0, width)), new Object[0]);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;
        @Parameter(names={"-z", "--zookeepers"}, description="the zookeepers to contact")
        String keepers = null;

        Opts() {
        }
    }
}

