/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactableUtils;
import org.apache.accumulo.tserver.tablet.MetadataUpdateCount;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatafileManager {
    private final Logger log = LoggerFactory.getLogger(DatafileManager.class);
    private final Map<StoredTabletFile, DataFileValue> datafileSizes = Collections.synchronizedMap(new TreeMap());
    private final Tablet tablet;
    private final Object bulkFileImportLock = new Object();
    private final AtomicReference<MetadataUpdateCount> metadataUpdateCount;
    private final Set<StoredTabletFile> filesToDeleteAfterScan = new HashSet<StoredTabletFile>();
    private final Map<Long, Set<StoredTabletFile>> scanFileReservations = new HashMap<Long, Set<StoredTabletFile>>();
    private final MapCounter<StoredTabletFile> fileScanReferenceCounts = new MapCounter();
    private long nextScanReservationId = 0L;

    DatafileManager(Tablet tablet, SortedMap<StoredTabletFile, DataFileValue> datafileSizes) {
        this.datafileSizes.putAll(datafileSizes);
        this.tablet = tablet;
        this.metadataUpdateCount = new AtomicReference<MetadataUpdateCount>(new MetadataUpdateCount(tablet.getExtent(), 0L, 0L));
    }

    static void rename(VolumeManager fs, Path src, Path dst) throws IOException {
        if (!fs.rename(src, dst)) {
            throw new IOException("Rename " + src + " to " + dst + " returned false ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Long, Map<StoredTabletFile, DataFileValue>> reserveFilesForScan() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            HashSet<StoredTabletFile> absFilePaths = new HashSet<StoredTabletFile>(this.datafileSizes.keySet());
            long rid = this.nextScanReservationId++;
            this.scanFileReservations.put(rid, absFilePaths);
            HashMap<StoredTabletFile, DataFileValue> ret = new HashMap<StoredTabletFile, DataFileValue>();
            for (StoredTabletFile path : absFilePaths) {
                this.fileScanReferenceCounts.increment((Object)path, 1L);
                ret.put(path, this.datafileSizes.get(path));
            }
            return new Pair((Object)rid, ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnFilesForScan(Long reservationId) {
        HashSet<StoredTabletFile> filesToDelete = new HashSet<StoredTabletFile>();
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            Set<StoredTabletFile> absFilePaths = this.scanFileReservations.remove(reservationId);
            if (absFilePaths == null) {
                throw new IllegalArgumentException("Unknown scan reservation id " + reservationId);
            }
            boolean notify = false;
            for (StoredTabletFile path : absFilePaths) {
                long refCount = this.fileScanReferenceCounts.decrement((Object)path, 1L);
                if (refCount == 0L) {
                    if (this.filesToDeleteAfterScan.remove(path)) {
                        filesToDelete.add(path);
                    }
                    notify = true;
                    continue;
                }
                if (refCount >= 0L) continue;
                throw new IllegalStateException("Scan ref count for " + path + " is " + refCount);
            }
            if (notify) {
                this.tablet.notifyAll();
            }
        }
        if (!filesToDelete.isEmpty()) {
            this.log.debug("Removing scan refs from metadata {} {}", (Object)this.tablet.getExtent(), filesToDelete);
            MetadataTableUtil.removeScanFiles((KeyExtent)this.tablet.getExtent(), filesToDelete, (ServerContext)this.tablet.getContext(), (ServiceLock)this.tablet.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFilesAfterScan(Set<StoredTabletFile> scanFiles) {
        if (scanFiles.isEmpty()) {
            return;
        }
        HashSet<StoredTabletFile> filesToDelete = new HashSet<StoredTabletFile>();
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            for (StoredTabletFile path : scanFiles) {
                if (this.fileScanReferenceCounts.get((Object)path) == 0L) {
                    filesToDelete.add(path);
                    continue;
                }
                this.filesToDeleteAfterScan.add(path);
            }
        }
        if (!filesToDelete.isEmpty()) {
            this.log.debug("Removing scan refs from metadata {} {}", (Object)this.tablet.getExtent(), filesToDelete);
            MetadataTableUtil.removeScanFiles((KeyExtent)this.tablet.getExtent(), filesToDelete, (ServerContext)this.tablet.getContext(), (ServiceLock)this.tablet.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<StoredTabletFile> waitForScansToFinish(Set<StoredTabletFile> pathsToWaitFor) {
        long maxWait = 10000L;
        long startTime = System.currentTimeMillis();
        TreeSet<StoredTabletFile> inUse = new TreeSet<StoredTabletFile>();
        Span span = TraceUtil.startSpan(this.getClass(), (String)"waitForScans");
        try (Scope scope = span.makeCurrent();){
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                for (StoredTabletFile path : pathsToWaitFor) {
                    while (this.fileScanReferenceCounts.get((Object)path) > 0L && System.currentTimeMillis() - startTime < maxWait) {
                        try {
                            this.tablet.wait(100L);
                        }
                        catch (InterruptedException e) {
                            this.log.warn("{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
                for (StoredTabletFile path : pathsToWaitFor) {
                    if (this.fileScanReferenceCounts.get((Object)path) <= 0L) continue;
                    inUse.add(path);
                }
            }
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span.end();
        }
        return inUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StoredTabletFile> importDataFiles(long tid, Map<ReferencedTabletFile, DataFileValue> paths, boolean setTime) throws IOException {
        String bulkDir = null;
        Map<Object, Object> newFiles = new HashMap(paths.size());
        for (ReferencedTabletFile tpath : paths.keySet()) {
            boolean inTheRightDirectory = false;
            Path parent = tpath.getPath().getParent().getParent();
            for (String tablesDir : this.tablet.getContext().getTablesDirs()) {
                if (!parent.equals((Object)new Path(tablesDir, this.tablet.getExtent().tableId().canonical()))) continue;
                inTheRightDirectory = true;
                break;
            }
            if (!inTheRightDirectory) {
                throw new IOException("Data file " + tpath + " not in table dirs");
            }
            if (bulkDir == null) {
                bulkDir = tpath.getTabletDir();
                continue;
            }
            if (bulkDir.equals(tpath.getTabletDir())) continue;
            throw new IllegalArgumentException("bulk files in different dirs " + bulkDir + " " + tpath);
        }
        if (this.tablet.getExtent().isMeta()) {
            throw new IllegalArgumentException("Can not import files to a metadata tablet");
        }
        this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementStart);
        try {
            Iterator<Map.Entry<Object, Object>> iterator = this.bulkFileImportLock;
            synchronized (iterator) {
                if (!paths.isEmpty()) {
                    long bulkTime = Long.MIN_VALUE;
                    if (setTime) {
                        for (DataFileValue dfv : paths.values()) {
                            long nextTime = this.tablet.getAndUpdateTime();
                            if (nextTime < bulkTime) {
                                throw new IllegalStateException("Time went backwards unexpectedly " + nextTime + " " + bulkTime);
                            }
                            bulkTime = nextTime;
                            dfv.setTime(bulkTime);
                        }
                    }
                    newFiles = this.tablet.updatePersistedTime(bulkTime, paths, tid);
                }
            }
            iterator = this.tablet;
            synchronized (iterator) {
                for (Map.Entry tpath : newFiles.entrySet()) {
                    if (this.datafileSizes.containsKey(tpath.getKey())) {
                        this.log.error("Adding file that is already in set {}", tpath.getKey());
                    }
                    this.datafileSizes.put((StoredTabletFile)tpath.getKey(), (DataFileValue)tpath.getValue());
                }
                this.tablet.getTabletResources().importedDataFiles();
                this.tablet.computeNumEntries();
            }
            for (Map.Entry<Object, Object> entry : newFiles.entrySet()) {
                TabletLogger.bulkImported((KeyExtent)this.tablet.getExtent(), (TabletFile)((TabletFile)entry.getKey()));
            }
        }
        finally {
            this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementFinish);
        }
        return newFiles.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<StoredTabletFile> bringMinorCompactionOnline(ReferencedTabletFile tmpDatafile, ReferencedTabletFile newDatafile, DataFileValue dfv, CommitSession commitSession, long flushId) {
        long t2;
        long t1;
        Optional<StoredTabletFile> newFile;
        boolean attemptedRename = false;
        VolumeManager vm = this.tablet.getTabletServer().getContext().getVolumeManager();
        while (true) {
            try {
                if (dfv.getNumEntries() == 0L) {
                    this.log.debug("No data entries so delete temporary file {}", (Object)tmpDatafile);
                    vm.deleteRecursively(tmpDatafile.getPath());
                    break;
                }
                if (!attemptedRename && vm.exists(newDatafile.getPath())) {
                    this.log.warn("Target data file already exist {}", (Object)newDatafile);
                    throw new RuntimeException("File unexpectedly exists " + newDatafile.getPath());
                }
                if (attemptedRename && vm.exists(newDatafile.getPath()) && !vm.exists(tmpDatafile.getPath())) break;
                attemptedRename = true;
                DatafileManager.rename(vm, tmpDatafile.getPath(), newDatafile.getPath());
            }
            catch (IOException ioe) {
                this.log.warn("Tablet " + this.tablet.getExtent() + " failed to rename " + newDatafile + " after MinC, will retry in 60 secs...", (Throwable)ioe);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MINUTES);
                continue;
            }
            break;
        }
        this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementStart);
        try {
            Set<String> unusedWalLogs = this.tablet.beginClearingUnusedLogs();
            try {
                newFile = this.tablet.updateTabletDataFile(commitSession.getMaxCommittedTime(), newDatafile, dfv, unusedWalLogs, flushId);
            }
            finally {
                this.tablet.finishClearingUnusedLogs();
            }
            while (true) {
                try {
                    this.tablet.getTabletServer().minorCompactionFinished(this.tablet.getTabletMemory().getCommitSession(), commitSession.getWALogSeq() + 2L);
                }
                catch (IOException e) {
                    this.log.error("Failed to write to write-ahead log " + e.getMessage() + " will retry", (Throwable)e);
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                t1 = System.currentTimeMillis();
                if (newFile.isPresent()) {
                    StoredTabletFile newFileStored = newFile.orElseThrow();
                    if (this.datafileSizes.containsKey(newFileStored)) {
                        this.log.error("Adding file that is already in set {}", (Object)newFileStored);
                    }
                    this.datafileSizes.put(newFileStored, dfv);
                }
                this.tablet.flushComplete(flushId);
                t2 = System.currentTimeMillis();
            }
        }
        finally {
            this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementFinish);
        }
        TabletLogger.flushed((KeyExtent)this.tablet.getExtent(), newFile);
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("MinC finish lock %.2f secs %s", (double)(t2 - t1) / 1000.0, this.tablet.getExtent().toString()));
        }
        long splitSize = this.tablet.getTableConfiguration().getAsBytes(Property.TABLE_SPLIT_THRESHOLD);
        if (dfv.getSize() > splitSize) {
            this.log.debug(String.format("Minor Compaction wrote out file larger than split threshold. split threshold = %,d  file size = %,d", splitSize, dfv.getSize()));
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<StoredTabletFile> bringMajorCompactionOnline(Set<StoredTabletFile> oldDatafiles, ReferencedTabletFile tmpDatafile, Long compactionId, Set<StoredTabletFile> selectedFiles, DataFileValue dfv, Optional<ExternalCompactionId> ecid) throws IOException {
        long t2;
        long t1;
        ReferencedTabletFile newDatafile;
        KeyExtent extent = this.tablet.getExtent();
        VolumeManager vm = this.tablet.getTabletServer().getContext().getVolumeManager();
        if (vm.exists((newDatafile = CompactableUtils.computeCompactionFileDest(tmpDatafile)).getPath())) {
            this.log.error("Target data file already exist " + newDatafile, (Throwable)new Exception());
            throw new IllegalStateException("Target data file already exist " + newDatafile);
        }
        if (dfv.getNumEntries() == 0L) {
            vm.deleteRecursively(tmpDatafile.getPath());
        } else {
            DatafileManager.rename(vm, tmpDatafile.getPath(), newDatafile.getPath());
        }
        TabletMetadata.Location lastLocation = null;
        Optional<Object> newFile = dfv.getNumEntries() > 0L ? Optional.of(newDatafile.insert()) : Optional.empty();
        Long compactionIdToWrite = null;
        this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementStart);
        try {
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                t1 = System.currentTimeMillis();
                Preconditions.checkState((boolean)this.datafileSizes.keySet().containsAll(oldDatafiles), (String)"Compacted files %s are not a subset of tablet files %s", oldDatafiles, this.datafileSizes.keySet());
                if (newFile.isPresent()) {
                    Preconditions.checkState((!this.datafileSizes.containsKey(newFile.orElseThrow()) ? 1 : 0) != 0, (String)"New compaction file %s already exist in tablet files %s", newFile, this.datafileSizes.keySet());
                }
                this.tablet.incrementDataSourceDeletions();
                this.datafileSizes.keySet().removeAll(oldDatafiles);
                if (newFile.isPresent()) {
                    this.datafileSizes.put((StoredTabletFile)newFile.orElseThrow(), dfv);
                }
                this.tablet.computeNumEntries();
                lastLocation = this.tablet.resetLastLocation();
                if (compactionId != null && Collections.disjoint(selectedFiles, this.datafileSizes.keySet())) {
                    compactionIdToWrite = compactionId;
                }
                t2 = System.currentTimeMillis();
            }
            TreeSet<StoredTabletFile> filesInUseByScans = this.waitForScansToFinish(oldDatafiles);
            if (!filesInUseByScans.isEmpty()) {
                this.log.debug("Adding scan refs to metadata {} {}", (Object)extent, filesInUseByScans);
            }
            ManagerMetadataUtil.replaceDatafiles((ServerContext)this.tablet.getContext(), (KeyExtent)extent, oldDatafiles, filesInUseByScans, newFile, (Long)compactionIdToWrite, (DataFileValue)dfv, (TServerInstance)this.tablet.getTabletServer().getTabletSession(), (TabletMetadata.Location)lastLocation, (ServiceLock)this.tablet.getTabletServer().getLock(), ecid);
            this.tablet.setLastCompactionID(compactionIdToWrite);
            this.removeFilesAfterScan(filesInUseByScans);
        }
        finally {
            this.metadataUpdateCount.updateAndGet(MetadataUpdateCount::incrementFinish);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("MajC finish lock %.2f secs", (double)(t2 - t1) / 1000.0));
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<StoredTabletFile, DataFileValue> getDatafileSizes() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            TreeMap<StoredTabletFile, DataFileValue> copy = new TreeMap<StoredTabletFile, DataFileValue>(this.datafileSizes);
            return Collections.unmodifiableSortedMap(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<StoredTabletFile> getFiles() {
        Tablet tablet = this.tablet;
        synchronized (tablet) {
            HashSet<StoredTabletFile> files = new HashSet<StoredTabletFile>(this.datafileSizes.keySet());
            return Collections.unmodifiableSet(files);
        }
    }

    public int getNumFiles() {
        return this.datafileSizes.size();
    }

    public MetadataUpdateCount getUpdateCount() {
        return this.metadataUpdateCount.get();
    }
}

